/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.contentgenerator;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.ui.internal.contentgenerator.ContentGenerator;
import org.w3c.dom.Element;

public class HttpContentGenerator
implements ContentGenerator {
    protected Definition definition;
    protected boolean isPost;
    protected String addressLocation = "http://tempuri.org/";
    protected static final String[] requiredNamespaces = new String[]{"http://schemas.xmlsoap.org/wsdl/mime/", "http://schemas.xmlsoap.org/wsdl/http/"};
    protected static final String[] preferredNamespacePrefixes = new String[]{"mime", "http"};

    public void init(Definition definition, Object generator, Object[] options) {
        this.definition = definition;
        if (options != null) {
            if (options.length > 0 && options[0] != null) {
                Boolean isPostOption = (Boolean)options[0];
                this.isPost = isPostOption;
            }
            if (options.length > 1 && options[1] != null) {
                this.addressLocation = (String)options[1];
            }
        }
    }

    public String[] getRequiredNamespaces() {
        return requiredNamespaces;
    }

    public String[] getPreferredNamespacePrefixes() {
        return preferredNamespacePrefixes;
    }

    public void generatePortContent(Element portElement, Port port) {
        Element element = this.createElement(portElement, "http", "address");
        element.setAttribute("location", this.addressLocation);
    }

    public void generateBindingContent(Element bindingElement, PortType portType) {
        Element element = this.createElement(bindingElement, "http", "binding");
        element.setAttribute("verb", this.isPost ? "POST" : "GET");
    }

    public void generateBindingOperationContent(Element bindingOperationElement, Operation operation) {
        Element element = this.createElement(bindingOperationElement, "http", "operation");
        element.setAttribute("location", "/" + operation.getName());
    }

    public void generateBindingInputContent(Element bindingInputElement, Input input) {
        if (this.isPost) {
            Element element = this.createElement(bindingInputElement, "mime", "content");
            element.setAttribute("type", "application/x-www-form-urlencoded");
        } else {
            this.createElement(bindingInputElement, "http", "urlEncoded");
        }
    }

    public void generateBindingOutputContent(Element bindingOutputElement, Output output) {
        Element element = this.createElement(bindingOutputElement, "mime", "content");
        element.setAttribute("type", "text/xml");
    }

    public void generateBindingFaultContent(Element bindingFaultElement, Fault fault) {
    }

    protected Element createElement(Element parentElement, String prefix, String elementName) {
        String name = prefix != null ? String.valueOf(prefix) + ":" + elementName : elementName;
        Element result = parentElement.getOwnerDocument().createElement(name);
        parentElement.appendChild(result);
        return result;
    }
}

