/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.BaseNodeAction;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DeleteNodeAction
extends BaseNodeAction {
    protected List list;

    public DeleteNodeAction(Node node) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE"));
        this.list = new Vector();
        this.list.add(node);
    }

    public DeleteNodeAction(List nodeList) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE"));
        this.list = new Vector();
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            this.list.add(it.next());
        }
    }

    public void run() {
        this.beginRecording();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                attr.getOwnerElement().removeAttributeNode(attr);
                continue;
            }
            Node parent = node.getParentNode();
            if (parent == null) continue;
            Node previousSibling = node.getPreviousSibling();
            if (previousSibling != null && this.isWhitespaceTextNode(previousSibling)) {
                parent.removeChild(previousSibling);
            }
            parent.removeChild(node);
        }
        this.endRecording();
    }

    protected boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    public Node getNode() {
        return this.list.size() > 0 ? (Node)this.list.get(0) : null;
    }

    public String getUndoDescription() {
        return WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE");
    }
}

