/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;

public class WSDLEditorResourceChangeHandler {
    protected WSDLEditor wsdlEditor;
    protected boolean isUpdateRequired;
    protected InternalResourceChangeListener resourceChangeListener;
    protected InternalPartListener partListener;

    public WSDLEditorResourceChangeHandler(WSDLEditor wsdlEditor) {
        this.wsdlEditor = wsdlEditor;
        this.resourceChangeListener = new InternalResourceChangeListener();
        this.partListener = new InternalPartListener();
    }

    public void attach() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.wsdlEditor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.partListener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.wsdlEditor.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.partListener);
    }

    protected Map computeDependencyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Definition definition = this.wsdlEditor.getDefinition();
        ResourceSet resourceSet = definition.eResource().getResourceSet();
        Iterator i = resourceSet.getResources().iterator();
        while (i.hasNext()) {
            String uri;
            Resource resource = (Resource)i.next();
            if (resource == definition.eResource() || map.get(uri = resource.getURI().toString()) != null) continue;
            map.put(uri, uri);
        }
        return map;
    }

    public void performReload() {
        boolean doReload = false;
        int policy = WSDLEditorPlugin.getInstance().getDependenciesChangedPolicy();
        if (policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_PROMPT) {
            doReload = MessageDialog.openQuestion((Shell)this.wsdlEditor.getSite().getShell(), (String)WSDLEditorPlugin.getWSDLString("_UI_DEPENDENCIES_CHANGED"), (String)WSDLEditorPlugin.getWSDLString("_UI_DEPENDENCIES_CHANGED_REFRESH"));
        } else if (policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_RELOAD) {
            doReload = true;
        }
        if (doReload) {
            this.wsdlEditor.reloadDependencies();
        }
    }

    public boolean isListeningToResourceChanges() {
        int policy = WSDLEditorPlugin.getInstance().getDependenciesChangedPolicy();
        return policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_PROMPT || policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_RELOAD;
    }

    class InternalResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected List list = new ArrayList();
        protected boolean isPending = false;
        protected int count = 0;

        InternalResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            Display display = Display.getCurrent();
            if (display != null && WSDLEditorResourceChangeHandler.this.isListeningToResourceChanges() && !WSDLEditorResourceChangeHandler.this.isUpdateRequired) {
                if (event.getType() == 1) {
                    IResourceDelta[] deltas = event.getDelta().getAffectedChildren();
                    int i = 0;
                    while (i < deltas.length) {
                        try {
                            deltas[i].accept((IResourceDeltaVisitor)this);
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                if (this.list.size() > 0 && !this.isPending) {
                    this.isPending = true;
                    display.timerExec(2000, (Runnable)new TimerEvent());
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && !this.list.contains(resource)) {
                this.list.add(resource);
            }
            return true;
        }

        class TimerEvent
        implements Runnable {
            public void run() {
                Iterator i = InternalResourceChangeListener.this.list.iterator();
                while (i.hasNext()) {
                    IResource resource = (IResource)i.next();
                    URI.createPlatformResourceURI((String)resource.getFullPath().toString()).toString();
                }
                Map dependencyMap = WSDLEditorResourceChangeHandler.this.computeDependencyMap();
                Iterator i2 = InternalResourceChangeListener.this.list.iterator();
                while (i2.hasNext()) {
                    IResource resource = (IResource)i2.next();
                    String platformPath = URI.createPlatformResourceURI((String)resource.getFullPath().toString()).toString();
                    if (dependencyMap.get(platformPath) == null) continue;
                    ((InternalResourceChangeListener)InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.isUpdateRequired = true;
                    if (((InternalResourceChangeListener)InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.wsdlEditor.getSite().getWorkbenchWindow().getPartService().getActivePart() != ((InternalResourceChangeListener)InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.wsdlEditor) continue;
                    ((InternalResourceChangeListener)InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.isUpdateRequired = false;
                    WSDLEditorResourceChangeHandler.this.performReload();
                }
                InternalResourceChangeListener.this.isPending = false;
                InternalResourceChangeListener.this.list = new ArrayList();
            }
        }
    }

    class InternalPartListener
    implements IPartListener {
        InternalPartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == WSDLEditorResourceChangeHandler.this.wsdlEditor && WSDLEditorResourceChangeHandler.this.isUpdateRequired) {
                WSDLEditorResourceChangeHandler.this.isUpdateRequired = false;
                WSDLEditorResourceChangeHandler.this.performReload();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

