/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorResourceChangeHandler;
import org.eclipse.wst.wsdl.ui.internal.WSDLMultiPageEditorPart;
import org.eclipse.wst.wsdl.ui.internal.WSDLSelectionManager;
import org.eclipse.wst.wsdl.ui.internal.WSDLTextEditor;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLMenuActionContributor;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLGraphViewer;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLEditPartFactory;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.outline.ExtensibleOutlineProvider;
import org.eclipse.wst.wsdl.ui.internal.outline.ModelAdapterContentProvider;
import org.eclipse.wst.wsdl.ui.internal.outline.ModelAdapterLabelProvider;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLNodeAssociationProvider;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLResourceUtil;
import org.eclipse.wst.wsdl.ui.internal.viewers.WSDLDetailsViewer;
import org.eclipse.wst.wsdl.ui.internal.viewers.WSDLDetailsViewerProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class WSDLEditor
extends WSDLMultiPageEditorPart
implements INavigationLocationProvider {
    protected ExtensibleOutlineProvider extensibleOutlineProvider;
    protected WSDLTextEditor textEditor;
    protected WSDLGraphViewer graphViewer;
    protected WSDLDetailsViewer detailsViewer;
    protected WSDLSelectionManager selectionManager = new WSDLSelectionManager();
    protected SashForm sashForm;
    int graphPageIndex;
    protected WSDLModelAdapter modelAdapter;
    protected WSDLEditorResourceChangeHandler resourceChangeHandler;
    protected WSDLElement clipboardElement;
    int sourcePageIndex = -1;
    int[] weights;
    private static Color dividerColor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (Exception exception) {}
    }

    public Object getAdapter(Class key) {
        Object result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result = key == clazz ? this.selectionManager : super.getAdapter(key);
        return result;
    }

    public void dispose() {
        this.extensibleOutlineProvider.inputChanged(null, null, null);
        if (this.resourceChangeHandler != null) {
            this.resourceChangeHandler.dispose();
        }
        super.dispose();
    }

    public WSDLSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public ExtensibleOutlineProvider getExtensibleOutlineProvider() {
        if (this.extensibleOutlineProvider == null) {
            this.extensibleOutlineProvider = new ExtensibleOutlineProvider(this);
        }
        return this.extensibleOutlineProvider;
    }

    public WSDLTextEditor getWSDLTextEditor() {
        return this.textEditor;
    }

    public WSDLGraphViewer getGraphViewer() {
        return this.graphViewer;
    }

    public IStructuredModel getStructuredModel() {
        return this.textEditor.getModel();
    }

    public Document getXMLDocument() {
        return ((IDOMModel)this.textEditor.getModel()).getDocument();
    }

    public Definition getDefinition() {
        return this.modelAdapter != null ? this.modelAdapter.getDefinition() : null;
    }

    protected void createPages() {
        try {
            if (this.resourceChangeHandler == null) {
                this.resourceChangeHandler = new WSDLEditorResourceChangeHandler(this);
                this.resourceChangeHandler.attach();
            }
            this.createSourcePage();
            this.addSourcePage();
            this.lookupOrCreateWSDLModel();
            this.createAndAddGraphPage();
            int pageIndexToShow = this.getDefaultPageIndex();
            this.setActivePage(pageIndexToShow);
            this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.getDefinition()));
        }
        catch (PartInitException exception) {
            throw new SourceEditingRuntimeException((Throwable)exception, WSDLEditorPlugin.getWSDLString("An_error_has_occurred_when1_ERROR_"));
        }
    }

    protected void lookupOrCreateWSDLModel() {
        block6: {
            try {
                IDOMDocument document = ((IDOMModel)this.getModel()).getDocument();
                if (!(document instanceof INodeNotifier)) break block6;
                INodeNotifier notifier = (INodeNotifier)document;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.modelAdapter = (WSDLModelAdapter)notifier.getAdapterFor((Object)clazz);
                if (this.modelAdapter == null) {
                    this.modelAdapter = new WSDLModelAdapter();
                    notifier.addAdapter((INodeAdapter)this.modelAdapter);
                    this.modelAdapter.createDefinition(document.getDocumentElement());
                }
            }
            catch (Exception exception) {}
        }
    }

    protected int getDefaultPageIndex() {
        if (WSDLEditorPlugin.getInstance().getDefaultPage().equals("org.eclipse.wst.wsdl.ui.internal.graphpage") && this.graphPageIndex != -1) {
            return this.graphPageIndex;
        }
        return this.sourcePageIndex;
    }

    protected StructuredTextEditor createTextEditor() {
        this.textEditor = new WSDLTextEditor(this);
        return this.textEditor;
    }

    protected void createSourcePage() throws PartInitException {
        super.createSourcePage();
        this.textEditor = (WSDLTextEditor)this.getTextEditor();
    }

    protected void addSourcePage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
        this.setPageText(this.sourcePageIndex, WSDLEditorPlugin.getWSDLString("_UI_TAB_SOURCE"));
        this.textEditor.update();
    }

    public void setDesignWeights(int[] weights, boolean updateSourceDesign) {
        this.weights = weights;
        if (updateSourceDesign) {
            this.sashForm.setWeights(weights);
        }
    }

    protected void pageChange(int arg) {
        super.pageChange(arg);
        if (!this.getPageText(arg).equals(WSDLEditorPlugin.getWSDLString("_UI_TAB_SOURCE"))) {
            this.getPageText(arg).equals(WSDLEditorPlugin.getWSDLString("_UI_TAB_GRAPH"));
        }
    }

    protected void createAndAddGraphPage() throws PartInitException {
        this.sashForm = new SashForm(this.getContainer(), 2048);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setOrientation(512);
        int[] nArray = new int[]{8, 3};
        this.graphPageIndex = this.addPage((Control)this.sashForm);
        this.setPageText(this.graphPageIndex, WSDLEditorPlugin.getWSDLString("_UI_TAB_GRAPH"));
        this.graphViewer = new WSDLGraphViewer(this);
        this.graphViewer.createControl((Composite)this.sashForm);
        if (dividerColor == null) {
            dividerColor = new Color((Device)this.getContainer().getDisplay(), 143, 141, 138);
        }
        this.getContainer().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Object source = e.getSource();
                if (source instanceof Composite) {
                    Composite comp = (Composite)source;
                    Rectangle boundary = comp.getClientArea();
                    e.gc.setForeground(dividerColor);
                    e.gc.drawLine(boundary.x, boundary.y, boundary.x + boundary.width, boundary.y);
                    WSDLEditor.this.setDesignWeights(WSDLEditor.this.sashForm.getWeights(), true);
                }
            }
        });
    }

    public void setFocus() {
        super.setFocus();
        int activePage = this.getActivePage();
        if (activePage == this.sourcePageIndex) {
            WSDLEditorPlugin.getInstance().setDefaultPage("org.eclipse.wst.wsdl.ui.internal.sourcepage");
        } else {
            WSDLEditorPlugin.getInstance().setDefaultPage("org.eclipse.wst.wsdl.ui.internal.graphpage");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reloadDependencies() {
        try {
            this.getGraphViewer().getComponentViewer().setPreserveExpansionEnabled(true);
            Definition definition = this.getDefinition();
            if (definition != null) {
                WSDLResourceUtil.reloadDirectives(definition);
                ComponentReferenceUtil.updateBindingReferences(definition);
                ComponentReferenceUtil.updatePortTypeReferences(definition);
                ComponentReferenceUtil.updateMessageReferences(definition);
                ComponentReferenceUtil.updateSchemaReferences(definition);
                definition.setDocumentationElement(definition.getDocumentationElement());
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getGraphViewer().getComponentViewer().setPreserveExpansionEnabled(false);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.getGraphViewer().getComponentViewer().setPreserveExpansionEnabled(false);
            return;
        }
    }

    public void openOnSelection(String specification) {
        EObject eObject = this.getDefinition().eResource().getEObject(specification);
        if (eObject != null) {
            this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)eObject));
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new InternalTextSelectionNavigationLocation((ITextEditor)this.textEditor, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new InternalTextSelectionNavigationLocation((ITextEditor)this.textEditor, true);
    }

    public WSDLElement getClipboardContents() {
        return this.clipboardElement;
    }

    public void setClipboardContents(WSDLElement element) {
        this.clipboardElement = element;
    }

    public static class BuiltInWSDLEditorExtension
    implements WSDLEditorExtension {
        public boolean isExtensionTypeSupported(int type) {
            return type == 1 || type == 2 || type == 5 || type == 4 || type == 3 || type == 7 || type == 8;
        }

        public boolean isApplicable(Object object) {
            return object instanceof WSDLElement && !(object instanceof XSDSchemaExtensibilityElement) || object instanceof WSDLGroupObject;
        }

        public Object createExtensionObject(int type, WSDLEditor wsdlEditor) {
            Object result = null;
            switch (type) {
                case 1: {
                    result = new ModelAdapterContentProvider(WSDLModelAdapterFactory.getWSDLModelAdapterFactory());
                    break;
                }
                case 2: {
                    result = new ModelAdapterLabelProvider(WSDLModelAdapterFactory.getWSDLModelAdapterFactory());
                    break;
                }
                case 4: {
                    result = new WSDLDetailsViewerProvider();
                    break;
                }
                case 3: {
                    result = new WSDLMenuActionContributor((IEditorPart)wsdlEditor);
                    break;
                }
                case 8: {
                    result = new WSDLNodeAssociationProvider();
                    break;
                }
                case 5: {
                    result = new WSDLEditPartFactory();
                }
            }
            return result;
        }
    }

    static class InternalTextSelectionNavigationLocation
    extends TextSelectionNavigationLocation {
        public InternalTextSelectionNavigationLocation(ITextEditor part, boolean initialize) {
            super(part, initialize);
        }

        protected IEditorPart getEditorPart() {
            IEditorPart part = super.getEditorPart();
            if (part instanceof WSDLEditor) {
                part = ((WSDLEditor)part).getTextEditor();
            }
            return part;
        }

        public String getText() {
            IEditorPart part = this.getEditorPart();
            if (part instanceof WSDLTextEditor) {
                return ((WSDLTextEditor)part).getWSDLEditor().getTitle();
            }
            return super.getText();
        }
    }
}

