/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerHelper;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.ejb.provider.BeanClassProviderHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.graphics.Image;

public class EJBAnnotationBeanDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    protected static final String ANNOTATIOM_IMAGE_DESC_STRING = "annotation_bean_overlay";
    protected static final String ANNOTATIOM_DISABLED_IMAGE_DESC_STRING = "dis_annotation_bean_overlay";
    private static final ImageDescriptor ANNOTATION_IMG_DESC = EJBAnnotationBeanDecorator.getImageDescriptor("annotation_bean_overlay");
    private static final ImageDescriptor ANNOTATION_DISABLED_IMG_DESC = EJBAnnotationBeanDecorator.getImageDescriptor("dis_annotation_bean_overlay");

    private boolean isAnnotatedSupported(EObject target) {
        boolean bAnnotationSupported = false;
        if (AnnotationsControllerHelper.INSTANCE.isAnnotated(target)) {
            bAnnotationSupported = true;
        }
        return bAnnotationSupported;
    }

    private AnnotationsController getControllerForProject(IProject targetProject) {
        AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(targetProject);
        return controller;
    }

    public void decorate(Object element, IDecoration decoration) {
        EnterpriseBean bean = null;
        if (element instanceof BeanClassProviderHelper) {
            BeanClassProviderHelper beanClassHelper = (BeanClassProviderHelper)element;
            bean = beanClassHelper.getEjb();
        } else if (element instanceof EnterpriseBean) {
            bean = (EnterpriseBean)element;
        }
        if (bean == null) {
            return;
        }
        if (this.isAnnotatedSupported((EObject)bean)) {
            if (this.isAnnotationEnabled(bean)) {
                if (ANNOTATION_IMG_DESC != null) {
                    decoration.addOverlay(ANNOTATION_IMG_DESC);
                }
            } else if (ANNOTATION_DISABLED_IMG_DESC != null) {
                decoration.addOverlay(ANNOTATION_DISABLED_IMG_DESC);
            }
        }
    }

    private boolean isAnnotationEnabled(EnterpriseBean bean) {
        IProject targetProject;
        AnnotationsController controller;
        IFile annotatedSource = null;
        if (AnnotationsControllerManager.INSTANCE.isAnyAnnotationsSupported() && (controller = this.getControllerForProject(targetProject = ProjectUtilities.getProject((EObject)bean))) != null) {
            annotatedSource = controller.getEnabledAnnotationFile((EObject)bean);
        }
        return annotatedSource != null;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    protected static ImageDescriptor getImageDescriptor(String imageFileName) {
        if (imageFileName != null) {
            return J2EEUIPlugin.getDefault().getImageDescriptor(imageFileName);
        }
        return null;
    }
}

