/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.ui.eclipse.WSDLValidator;

class WSDLValidatorPluginRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsdl.validation";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_NAMESPACE = "namespace";
    protected static final String ATT_RESOURCEBUNDLE = "resourcebundle";
    protected static final int WSDL_VALIDATOR = 0;
    protected static final int EXT_VALIDATOR = 1;
    protected String extensionPointId;
    protected String tagName;
    protected int validatorType;

    public WSDLValidatorPluginRegistryReader(String extensionPointId, String tagName, int validatorType) {
        this.extensionPointId = extensionPointId;
        this.tagName = tagName;
        this.validatorType = validatorType;
    }

    public void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, this.extensionPointId);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(this.tagName)) {
            String validatorClass = element.getAttribute(ATT_CLASS);
            String namespace = element.getAttribute(ATT_NAMESPACE);
            String resourceBundle = element.getAttribute(ATT_RESOURCEBUNDLE);
            if (validatorClass != null) {
                try {
                    ClassLoader pluginLoader = element.getDeclaringExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
                    if (this.validatorType == 1) {
                        WSDLValidatorDelegate delegate = new WSDLValidatorDelegate(validatorClass, resourceBundle, pluginLoader);
                        WSDLValidator.getInstance().registerWSDLExtensionValidator(namespace, delegate);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

