/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.reference;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.application.impl.ApplicationImpl;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.reference.EJBReferenceCreationOperation;
import org.eclipse.jst.j2ee.internal.reference.ReferenceDataModel;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class EJBReferenceDataModel
extends ReferenceDataModel {
    public static final String TARGET = "EJBReferenceDataModel.TARGET";
    public static final String LOCAL_REMOTE_TYPE = "EJBReferenceDataModel.LOCAL_REMOTE_TYPE";
    public static final String IS_LOCAL = "EJBReferenceDataModel.IS_LOCAL";
    public static final String TARGET_IN_DIFFERENT_EAR = "EJBReferenceDataModel.TARGET_IN_DIFFERENT_EAR";
    public static final String LINK = "EJBReferenceDataModel.LINK";
    public static final String REF_TYPE = "EJBReferenceDataModel.REF_TYPE";
    public static final String HOME_INTERFACE = "EJBReferenceDataModel.HOME_INTERFACE";
    public static final String REMOTE_INTERACE = "EJBReferenceDataModel.REMOTE_INTERACE";
    public static final String CREATE_VALID_DEFAULT_NAME = "EJBReferenceDataModel.CREATE_VALID_DEFAULT_NAME";
    public static final String IS_DEFAULT_LOCAL_OR_REMOTE = "EJBReferenceDataModel.IS_DEFAULT_LOCAL_OR_REMOTE";
    public static final String IN_WORKSPACE = "EJBReferenceDataModel.IN_WORKSPACE";
    public static final String TARGET_EAR = "EJBReferenceDataModel.TARGET_EAR";
    public static final String TARGET_ALSO_EXIST_IN_SAME_EAR = "EJBReferenceDataModel.ALSO_EXIST_IN_SAME_EAR";
    public static final String TARGET_IN_SAME_PROJECT = "EJBReferenceDataModel.TARGET_IN_SAME_PROJECT";
    public static final String TARGET_ALSO_IN_EAR = "EJBReferenceDataModel.TARGET_ALSO_IN_EAR";
    public static final String TARGET_AND_SOURCE_HAVE_SAME_EARS = "EJBReferenceDataModel.TARGET_AND_SOURCE_HAVE_SAME_EARS";
    public static final String EMPTY_STRING = "";
    private static final String LOCAL_STRING = "Local";
    private static final String REMOTE_STRING = "Remote";

    protected void init() {
        super.init();
    }

    protected void initValidBaseProperties() {
        this.addValidBaseProperty(TARGET);
        this.addValidBaseProperty(LOCAL_REMOTE_TYPE);
        this.addValidBaseProperty(IS_LOCAL);
        this.addValidBaseProperty(TARGET_IN_DIFFERENT_EAR);
        this.addValidBaseProperty(LINK);
        this.addValidBaseProperty(REF_TYPE);
        this.addValidBaseProperty(HOME_INTERFACE);
        this.addValidBaseProperty(REMOTE_INTERACE);
        this.addValidBaseProperty(CREATE_VALID_DEFAULT_NAME);
        this.addValidBaseProperty(IN_WORKSPACE);
        this.addValidBaseProperty(IS_DEFAULT_LOCAL_OR_REMOTE);
        this.addValidBaseProperty(TARGET_EAR);
        this.addValidBaseProperty(TARGET_ALSO_EXIST_IN_SAME_EAR);
        this.addValidBaseProperty(TARGET_IN_SAME_PROJECT);
        this.addValidBaseProperty(TARGET_ALSO_IN_EAR);
        this.addValidBaseProperty(TARGET_AND_SOURCE_HAVE_SAME_EARS);
        super.initValidBaseProperties();
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean status = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals("ReferenceDataModel.OWNER") || propertyName.equals(TARGET)) {
            this.computeTargetInEAR();
        }
        if (propertyName.equals(TARGET)) {
            if (this.getBooleanProperty(CREATE_VALID_DEFAULT_NAME)) {
                this.setProperty("ReferenceDataModel.REF_NAME", this.calculateDefaultName());
                this.setBooleanProperty(CREATE_VALID_DEFAULT_NAME, true);
            }
            this.setProperty(REF_TYPE, this.calculateRefType());
            this.notifyDefaultChange(REF_TYPE);
            this.setProperty(LINK, this.calculateLink());
            this.notifyDefaultChange(LINK);
            this.setProperty(LOCAL_REMOTE_TYPE, this.getDefaultLocalRemote());
            this.notifyDefaultChange(LOCAL_REMOTE_TYPE);
            this.notifyEnablementChange(LOCAL_REMOTE_TYPE);
            this.setProperty(HOME_INTERFACE, this.calculateHomeInterface());
            this.notifyDefaultChange(HOME_INTERFACE);
            this.setProperty(REMOTE_INTERACE, this.calculateRemoteInterface());
            this.notifyDefaultChange(REMOTE_INTERACE);
        } else if (propertyName.equals("ReferenceDataModel.REF_NAME")) {
            String val;
            String string = val = propertyValue != null ? ((String)propertyValue).trim() : EMPTY_STRING;
            if (EMPTY_STRING.equals(val)) {
                this.setBooleanProperty(CREATE_VALID_DEFAULT_NAME, true);
            } else {
                this.setBooleanProperty(CREATE_VALID_DEFAULT_NAME, false);
            }
        } else if (propertyName.equals(LOCAL_REMOTE_TYPE)) {
            this.setProperty(IS_LOCAL, this.calculateLocalValue());
            this.notifyDefaultChange(IS_LOCAL);
            this.setProperty(HOME_INTERFACE, this.calculateHomeInterface());
            this.notifyDefaultChange(HOME_INTERFACE);
            this.setProperty(REMOTE_INTERACE, this.calculateRemoteInterface());
            this.notifyDefaultChange(REMOTE_INTERACE);
        } else if (propertyName.equals(TARGET_IN_DIFFERENT_EAR)) {
            this.setProperty(LINK, this.calculateLink());
            this.notifyDefaultChange(LINK);
        } else if (propertyName.equals(IN_WORKSPACE)) {
            if (!this.getBooleanProperty(IN_WORKSPACE)) {
                this.setBooleanProperty(TARGET_IN_DIFFERENT_EAR, true);
            }
            this.notifyEnablementChange(LOCAL_REMOTE_TYPE);
        } else if (propertyName.equals(TARGET_EAR)) {
            this.setProperty(TARGET, null);
        }
        return status;
    }

    private void computeTargetInEAR() {
        if (this.isSet("ReferenceDataModel.OWNER") && this.isSet(TARGET)) {
            this.setBooleanProperty(TARGET_ALSO_EXIST_IN_SAME_EAR, false);
            this.setBooleanProperty(TARGET_IN_SAME_PROJECT, false);
            this.setProperty(TARGET_ALSO_IN_EAR, null);
            this.setBooleanProperty(TARGET_AND_SOURCE_HAVE_SAME_EARS, false);
            EnterpriseBean target = (EnterpriseBean)this.getProperty(TARGET);
            IProject sourceProject = this.getTargetProject();
            IProject targetProject = J2EEProjectUtilities.getProject((EObject)target);
            boolean foundEAR = false;
            if (targetProject.equals((Object)sourceProject)) {
                this.setBooleanProperty(TARGET_IN_SAME_PROJECT, true);
                this.setBooleanProperty(TARGET_AND_SOURCE_HAVE_SAME_EARS, true);
                foundEAR = true;
            } else {
                int i;
                EARNatureRuntime[] sourceEARs = J2EEProjectUtilities.getReferencingEARProjects(sourceProject);
                EARNatureRuntime[] targetEARs = J2EEProjectUtilities.getReferencingEARProjects(targetProject);
                ApplicationImpl app = (ApplicationImpl)this.getProperty(TARGET_EAR);
                IProject earProject = app != null ? J2EEProjectUtilities.getProject((EObject)app) : null;
                boolean bSameEARsForSourceAndTarget = true;
                if (sourceEARs.length == targetEARs.length) {
                    i = 0;
                    while (bSameEARsForSourceAndTarget && i < sourceEARs.length) {
                        boolean bFind = false;
                        int j = 0;
                        while (!bFind && j < targetEARs.length) {
                            if (sourceEARs[i] == targetEARs[j]) {
                                bFind = true;
                            }
                            ++j;
                        }
                        bSameEARsForSourceAndTarget = bFind;
                        ++i;
                    }
                } else {
                    bSameEARsForSourceAndTarget = false;
                }
                if (bSameEARsForSourceAndTarget) {
                    foundEAR = true;
                    this.setBooleanProperty(TARGET_AND_SOURCE_HAVE_SAME_EARS, true);
                } else {
                    this.setBooleanProperty(TARGET_AND_SOURCE_HAVE_SAME_EARS, false);
                    i = 0;
                    while (!foundEAR && i < sourceEARs.length) {
                        int j = 0;
                        while (!foundEAR && j < targetEARs.length) {
                            if (sourceEARs[i] == targetEARs[j]) {
                                if (earProject != null) {
                                    if (sourceEARs[i].getProject() != null && sourceEARs[i].getProject() == earProject) {
                                        foundEAR = true;
                                    } else {
                                        this.setBooleanProperty(TARGET_ALSO_EXIST_IN_SAME_EAR, true);
                                        this.setProperty(TARGET_ALSO_IN_EAR, sourceEARs[i].getProject());
                                    }
                                } else {
                                    foundEAR = true;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            this.setBooleanProperty(TARGET_IN_DIFFERENT_EAR, !foundEAR);
        }
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(IS_LOCAL)) {
            return this.calculateLocalValue();
        }
        if (propertyName.equals("ReferenceDataModel.REF_NAME")) {
            return this.calculateDefaultName();
        }
        if (propertyName.equals(REF_TYPE)) {
            return this.calculateRefType();
        }
        if (propertyName.equals(LOCAL_REMOTE_TYPE)) {
            return this.getDefaultLocalRemote();
        }
        if (propertyName.equals(LINK)) {
            return this.calculateLink();
        }
        if (propertyName.equals(HOME_INTERFACE)) {
            return this.calculateHomeInterface();
        }
        if (propertyName.equals(REMOTE_INTERACE)) {
            return this.calculateRemoteInterface();
        }
        if (propertyName.equals(TARGET_IN_DIFFERENT_EAR)) {
            return Boolean.FALSE;
        }
        if (propertyName.equals(CREATE_VALID_DEFAULT_NAME)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(IN_WORKSPACE)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(TARGET_ALSO_EXIST_IN_SAME_EAR)) {
            return Boolean.FALSE;
        }
        if (propertyName.equals(TARGET_IN_SAME_PROJECT)) {
            return Boolean.FALSE;
        }
        if (propertyName.equals(TARGET_ALSO_IN_EAR)) {
            return null;
        }
        return super.getDefaultProperty(propertyName);
    }

    private String calculateRemoteInterface() {
        EnterpriseBean targetBean = (EnterpriseBean)this.getProperty(TARGET);
        if (targetBean != null) {
            if (this.getBooleanProperty(IS_LOCAL)) {
                return targetBean.getLocalInterfaceName();
            }
            return targetBean.getRemoteInterfaceName();
        }
        return EMPTY_STRING;
    }

    private Object calculateHomeInterface() {
        EnterpriseBean targetBean = (EnterpriseBean)this.getProperty(TARGET);
        if (targetBean != null) {
            if (this.getBooleanProperty(IS_LOCAL)) {
                return targetBean.getLocalHomeInterfaceName();
            }
            return targetBean.getHomeInterfaceName();
        }
        return EMPTY_STRING;
    }

    private Object calculateLink() {
        EnterpriseBean targetBean = (EnterpriseBean)this.getProperty(TARGET);
        if (this.getBooleanProperty(TARGET_IN_DIFFERENT_EAR)) {
            return EMPTY_STRING;
        }
        if (targetBean != null) {
            return this.computeLink();
        }
        return EMPTY_STRING;
    }

    private String calculateRefType() {
        EnterpriseBean targetBean = (EnterpriseBean)this.getProperty(TARGET);
        return targetBean != null && targetBean.isEntity() ? "Entity" : "Session";
    }

    private Boolean calculateLocalValue() {
        String type = this.getStringProperty(LOCAL_REMOTE_TYPE);
        if (type == null) {
            return Boolean.TRUE;
        }
        if (type.equals(LOCAL_STRING)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected boolean isTargetJ2EEVersion12() {
        EObject target = (EObject)this.getProperty(TARGET);
        if (target != null && target instanceof EnterpriseBean) {
            return ((EnterpriseBean)this.getProperty(TARGET)).getVersionID() <= 11;
        }
        return false;
    }

    private boolean isOwnerJ2EEVersion12() {
        return this.ownerType == 0 && ((EnterpriseBean)this.getProperty("ReferenceDataModel.OWNER")).getVersionID() <= 11 || this.ownerType == 1 && ((ApplicationClient)this.getProperty("ReferenceDataModel.OWNER")).getVersionID() <= 12 || this.ownerType == 2 && ((WebApp)this.getProperty("ReferenceDataModel.OWNER")).getVersionID() <= 22;
    }

    private String getDefaultLocalRemote() {
        EnterpriseBean target = (EnterpriseBean)this.getProperty(TARGET);
        String type = REMOTE_STRING;
        if (this.ownerType == 1) {
            type = REMOTE_STRING;
        } else if (this.getBooleanProperty(IN_WORKSPACE)) {
            if (target != null) {
                type = this.isOwnerJ2EEVersion12() ? REMOTE_STRING : (!this.getBooleanProperty(TARGET_IN_DIFFERENT_EAR) ? (target.hasLocalClient() ? LOCAL_STRING : REMOTE_STRING) : (target.hasRemoteClient() ? REMOTE_STRING : LOCAL_STRING));
            }
        } else {
            type = REMOTE_STRING;
        }
        return type;
    }

    private Object calculateDefaultName() {
        EnterpriseBean targetBean = (EnterpriseBean)this.getProperty(TARGET);
        if (targetBean != null) {
            if (this.getBooleanProperty(CREATE_VALID_DEFAULT_NAME)) {
                return this.calculateUniqueDefaultName(targetBean.getName());
            }
            return "ejb/" + targetBean.getName();
        }
        return null;
    }

    private Object calculateUniqueDefaultName(String beanName) {
        String refName = "ejb/" + beanName;
        if (this.validateReferenceDoesNotExist(refName)) {
            return refName;
        }
        int i = 1;
        while (i < 20) {
            refName = "ejb/" + beanName + "_" + i;
            if (this.validateReferenceDoesNotExist(refName)) {
                return refName;
            }
            ++i;
        }
        return refName;
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = super.doValidateProperty(propertyName);
        if (status.isOK()) {
            if (propertyName.equals(TARGET) && this.getBooleanProperty(IN_WORKSPACE)) {
                Object target = this.getProperty(TARGET);
                if (target == null || !(target instanceof EnterpriseBean)) {
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("EJBReferenceDataModel_UI_12"));
                }
                if (!this.getBooleanProperty(TARGET_IN_SAME_PROJECT) && this.getBooleanProperty(TARGET_IN_DIFFERENT_EAR) && this.getBooleanProperty(TARGET_ALSO_EXIST_IN_SAME_EAR)) {
                    IProject ownerProject = this.getOwnerProject();
                    IProject project = (IProject)this.getProperty(TARGET_ALSO_IN_EAR);
                    if (project != null && ownerProject != null) {
                        EARNatureRuntime earRuntime = EARNatureRuntime.getRuntime(project);
                        return WTPCommonPlugin.createWarningStatus((String)J2EECreationResourceHandler.getString("TARGET_ALSO_EXIST_IN_SAME_EAR", new String[]{earRuntime.getApplication().getDisplayName(), ownerProject.getName()}));
                    }
                }
            } else if (propertyName.equals(LOCAL_REMOTE_TYPE)) {
                EnterpriseBean target;
                if (this.ownerType == 1 && this.getBooleanProperty(IS_LOCAL)) {
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("APP_CLIENT_ONLY_HAVE_REMOTE"));
                }
                if (this.isOwnerJ2EEVersion12() && this.getBooleanProperty(IS_LOCAL)) {
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("J2EE_1_2_ONLY_HAVE_REMOTE"));
                }
                if (this.getBooleanProperty(IS_LOCAL) && (!this.getBooleanProperty(IN_WORKSPACE) || this.getBooleanProperty(TARGET_IN_DIFFERENT_EAR))) {
                    return WTPCommonPlugin.createWarningStatus((String)J2EECreationResourceHandler.getString("USE_REMOTE_FOR_DIFFERENT_EAR"));
                }
                if (!(this.getBooleanProperty(IS_LOCAL) || !this.getBooleanProperty(IN_WORKSPACE) || this.getBooleanProperty(TARGET_IN_DIFFERENT_EAR) || this.ownerType == 1 || this.isOwnerJ2EEVersion12() || this.isTargetJ2EEVersion12() || (target = (EnterpriseBean)this.getProperty(TARGET)).getVersionID() <= 11)) {
                    return WTPCommonPlugin.createWarningStatus((String)J2EECreationResourceHandler.getString("USE_LOCAL_FOR_DIFFERENT_EAR"));
                }
            } else if (propertyName.equals(HOME_INTERFACE) && (this.getProperty(HOME_INTERFACE) == null || this.getStringProperty(HOME_INTERFACE).length() == 0) || propertyName.equals(REMOTE_INTERACE) && (this.getProperty(REMOTE_INTERACE) == null || this.getStringProperty(REMOTE_INTERACE).length() == 0)) {
                if (this.getBooleanProperty(IN_WORKSPACE)) {
                    if (this.getBooleanProperty(IS_LOCAL)) {
                        return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("EJBReferenceDataModel_UI_10"));
                    }
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("EJBReferenceDataModel_UI_11"));
                }
                if (this.getBooleanProperty(IS_LOCAL)) {
                    if (propertyName.equals(HOME_INTERFACE)) {
                        return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("Local_home_cannot_be_empty_UI_"));
                    }
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("Local_cannot_be_empty_UI_"));
                }
                if (propertyName.equals(HOME_INTERFACE)) {
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("Home_cannot_be_empty_UI_"));
                }
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.getString("Remote_cannot_be_empty_UI_"));
            }
        }
        return status;
    }

    public String computeLink() {
        EnterpriseBean targetBean = (EnterpriseBean)this.getProperty(TARGET);
        if (targetBean == null) {
            return EMPTY_STRING;
        }
        IProject targetModuleProject = ProjectUtilities.getProject((EObject)targetBean.getEjbJar());
        if (targetModuleProject == null) {
            return EMPTY_STRING;
        }
        IProject ownerProject = this.getOwnerProject();
        if (targetModuleProject.equals((Object)ownerProject)) {
            return targetBean.getName();
        }
        if (this.ownerType == 0 && ((EnterpriseBean)this.getProperty("ReferenceDataModel.OWNER")).getVersionID() <= 11 || this.ownerType == 1 && ((ApplicationClient)this.getProperty("ReferenceDataModel.OWNER")).getVersionID() == 12) {
            return targetBean.getName();
        }
        return this.calculateLinkForEARRelativeBean(targetBean, ownerProject, targetModuleProject);
    }

    public IProject getOwnerProject() {
        IProject ownerProject = null;
        if (this.ownerType == 0) {
            EnterpriseBean ownerBean = (EnterpriseBean)this.getProperty("ReferenceDataModel.OWNER");
            ownerProject = ProjectUtilities.getProject((EObject)ownerBean.getEjbJar());
        } else if (this.ownerType == 1 || this.ownerType == 2) {
            ownerProject = ProjectUtilities.getProject((Object)this.getProperty("ReferenceDataModel.OWNER"));
        }
        return ownerProject;
    }

    private String calculateLinkForEARRelativeBean(EnterpriseBean bean, IProject ownerProject, IProject targetModuleProject) {
        J2EEModuleNature targetNature = (J2EEModuleNature)J2EENature.getRuntime(targetModuleProject, "org.eclipse.jst.j2ee.ejb.EJBNature");
        if (targetNature == null) {
            return EMPTY_STRING;
        }
        EARNatureRuntime[] runtimes = targetNature.getReferencingEARProjects();
        if (runtimes.length < 1) {
            return EMPTY_STRING;
        }
        Module targetModule = runtimes[0].getModule(targetModuleProject);
        J2EEModuleNature ownerNature = null;
        Module ownerModule = null;
        if (this.ownerType == 0) {
            ownerNature = (J2EEModuleNature)J2EEModuleNature.getRuntime(ownerProject, "org.eclipse.jst.j2ee.ejb.EJBNature");
        } else if (this.ownerType == 1) {
            ownerNature = (J2EEModuleNature)J2EEModuleNature.getRuntime(ownerProject, "org.eclipse.jst.j2ee.ApplicationClientNature");
        } else if (this.ownerType == 2) {
            ownerNature = (J2EEModuleNature)J2EEModuleNature.getRuntime(ownerProject, "org.eclipse.jst.j2ee.web.WebNature");
        }
        if (ownerNature == null) {
            return EMPTY_STRING;
        }
        runtimes = ownerNature.getReferencingEARProjects();
        if (runtimes.length < 1) {
            return EMPTY_STRING;
        }
        ownerModule = runtimes[0].getModule(ownerProject);
        if (ownerModule == null || targetModule == null) {
            return EMPTY_STRING;
        }
        return J2EEProjectUtilities.computeRelativeText(ownerModule.getUri(), targetModule.getUri(), bean);
    }

    public WTPOperation getDefaultOperation() {
        return new EJBReferenceCreationOperation(this);
    }

    protected Boolean basicIsEnabled(String propertyName) {
        if (propertyName.equals(LOCAL_REMOTE_TYPE)) {
            if (this.getBooleanProperty(IN_WORKSPACE)) {
                if (this.getProperty(TARGET) == null) {
                    return Boolean.FALSE;
                }
                if (this.ownerType == 1 || this.isOwnerJ2EEVersion12() || this.isTargetJ2EEVersion12()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (this.ownerType == 1 || this.isOwnerJ2EEVersion12()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return super.basicIsEnabled(propertyName);
    }

    public boolean shouldCreateClientJar() {
        boolean isInWorkspace = this.getBooleanProperty(IN_WORKSPACE);
        boolean isInSameProject = this.getBooleanProperty(TARGET_IN_SAME_PROJECT);
        boolean isTargetAndSourceHaveSameEars = this.getBooleanProperty(TARGET_AND_SOURCE_HAVE_SAME_EARS);
        if (isInWorkspace) {
            if (isInSameProject) {
                return false;
            }
            return !isTargetAndSourceHaveSameEars;
        }
        return false;
    }
}

