/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMapping;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class J2EEProjectUtilities
extends ProjectUtilities {
    public static boolean isBinaryProject(String jarUri, IProject aProject) {
        return JemProjectUtilities.isBinaryProject((IProject)aProject);
    }

    public static IPath getRuntimeLocation(IProject aProject) {
        if (JemProjectUtilities.isBinaryProject((IProject)aProject)) {
            return J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        }
        return JemProjectUtilities.getJavaProjectOutputAbsoluteLocation((IProject)aProject);
    }

    public static IPath getBinaryProjectJARLocation(IProject aProject) {
        List sources = JemProjectUtilities.getLocalJARPathsFromClasspath((IProject)aProject);
        if (!sources.isEmpty()) {
            IPath path = (IPath)sources.get(0);
            return aProject.getFile(path).getLocation();
        }
        return null;
    }

    public static Archive getClientJAR(EJBJarFile file, EARFile earFile) {
        EJBJar jar = file.getDeploymentDescriptor();
        if (jar == null) {
            return null;
        }
        String clientJAR = jar.getEjbClientJar();
        if (clientJAR == null || clientJAR.length() == 0) {
            return null;
        }
        String normalized = ArchiveUtil.deriveEARRelativeURI((String)clientJAR, (String)file.getURI());
        if (normalized != null) {
            try {
                File aFile = earFile.getFile(normalized);
                if (aFile.isArchive() && !aFile.isModuleFile()) {
                    return (Archive)aFile;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (Platform.getOS().equals("win32")) {
                if (entry.getPath().toString().equalsIgnoreCase(newEntry.getPath().toString())) return;
                newPathList.add(entry);
            } else {
                if (entry.getPath().equals((Object)newEntry.getPath())) return;
                newPathList.add(entry);
            }
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Archive asArchiveFromBinary(String jarUri, IProject aProject) throws OpenFailureException {
        IPath path = J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        if (path != null) {
            String location = path.toOSString();
            Archive anArchive = CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive(location);
            anArchive.setURI(jarUri);
            return anArchive;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EARNatureRuntime[] getReferencingEARProjects(IProject aProject) {
        List earProjects = EARNatureRuntime.getAllEARProjectsInWorkbench();
        ArrayList<EARNatureRuntime> result = new ArrayList<EARNatureRuntime>();
        EAREditModel editModel = null;
        int i = 0;
        while (i < earProjects.size()) {
            block8: {
                Object var10_10;
                IProject earProject = (IProject)earProjects.get(i);
                EARNatureRuntime earNature = EARNatureRuntime.getRuntime(earProject);
                Object accessorKey = new Object();
                try {
                    editModel = earNature.getEarEditModelForRead(accessorKey);
                    UtilityJARMapping map = editModel.getUtilityJARMapping(aProject);
                    if (map != null) {
                        result.add(earNature);
                    } else {
                        ModuleMapping modMap = editModel.getModuleMapping(aProject);
                        if (modMap != null) {
                            result.add(earNature);
                        }
                    }
                    var10_10 = null;
                    if (editModel == null) break block8;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    if (editModel != null) {
                        editModel.releaseAccess(accessorKey);
                    }
                    throw throwable;
                }
                editModel.releaseAccess(accessorKey);
            }
            ++i;
        }
        return result.toArray(new EARNatureRuntime[result.size()]);
    }

    public static EARNatureRuntime getFirstReferencingEARProject(IProject aProject) {
        EARNatureRuntime[] natures = J2EEProjectUtilities.getReferencingEARProjects(aProject);
        if (natures.length != 0) {
            return natures[0];
        }
        return null;
    }

    public static String getJARUri(EARNatureRuntime runtime, IProject project) {
        return runtime.getJARUri(project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IFile aFile) {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in;
        block11: {
            ArchiveManifest archiveManifest;
            block10: {
                in = null;
                try {
                    try {
                        if (aFile == null || !aFile.exists()) {
                            archiveManifest = null;
                            Object var3_5 = null;
                            if (in == null) return archiveManifest;
                            break block10;
                        }
                        in = aFile.getContents();
                        archiveManifestImpl = new ArchiveManifestImpl(in);
                        break block11;
                    }
                    catch (Exception ex) {
                        Logger.getLogger().logError((Throwable)ex);
                        ArchiveManifest archiveManifest2 = null;
                        Object var3_7 = null;
                        if (in == null) return archiveManifest2;
                        try {
                            in.close();
                            return archiveManifest2;
                        }
                        catch (IOException iOException) {}
                        return archiveManifest2;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    if (in == null) throw throwable;
                    try {}
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    in.close();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            in.close();
            return archiveManifest;
        }
        Object var3_6 = null;
        if (in == null) return archiveManifestImpl;
        try {}
        catch (IOException iOException) {}
        in.close();
        return archiveManifestImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IProject p) {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in;
        block11: {
            ArchiveManifest archiveManifest;
            block10: {
                in = null;
                try {
                    try {
                        IFile aFile = J2EEProjectUtilities.getManifestFile(p);
                        if (aFile == null || !aFile.exists()) {
                            archiveManifest = null;
                            Object var3_7 = null;
                            if (in == null) return archiveManifest;
                            break block10;
                        }
                        in = aFile.getContents();
                        archiveManifestImpl = new ArchiveManifestImpl(in);
                        break block11;
                    }
                    catch (Exception ex) {
                        Logger.getLogger().logError((Throwable)ex);
                        ArchiveManifest archiveManifest2 = null;
                        Object var3_9 = null;
                        if (in == null) return archiveManifest2;
                        try {
                            in.close();
                            return archiveManifest2;
                        }
                        catch (IOException iOException) {}
                        return archiveManifest2;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_10 = null;
                    if (in == null) throw throwable;
                    try {}
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    in.close();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            in.close();
            return archiveManifest;
        }
        Object var3_8 = null;
        if (in == null) return archiveManifestImpl;
        try {}
        catch (IOException iOException) {}
        in.close();
        return archiveManifestImpl;
    }

    public static IFile getManifestFile(IProject p) {
        IFlexibleProject core = ComponentCore.createFlexibleProject((IProject)p);
        IVirtualComponent component = core.getComponents()[0];
        try {
            return ComponentUtilities.findFile((IVirtualComponent)component, (IPath)new Path("MANIFEST.MF"));
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
            return null;
        }
    }

    public static void writeManifest(IProject p, ArchiveManifest manifest) throws IOException {
        IFile aFile = J2EEProjectUtilities.getManifestFile(p);
        if (aFile != null) {
            WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(aFile);
            manifest.writeSplittingClasspath((OutputStream)out);
            out.close();
        }
    }

    public static void writeManifest(IFile aFile, ArchiveManifest manifest) throws IOException {
        if (aFile != null) {
            WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(aFile);
            manifest.writeSplittingClasspath((OutputStream)out);
            out.close();
        }
    }

    public static String getUtilityJARUriInFirstEAR(IProject project) {
        EARNatureRuntime[] earNatures = J2EEProjectUtilities.getReferencingEARProjects(project);
        int i = 0;
        while (i < earNatures.length) {
            String uri = J2EEProjectUtilities.getJARUri(earNatures[i], project);
            if (uri != null && uri.length() > 0) {
                return uri;
            }
            ++i;
        }
        return null;
    }

    public static Map collectEJBClientJARs(EARFile earFile) {
        if (earFile == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<EJBJarFile, Archive> ejbClientJARs = null;
        List ejbJARFiles = earFile.getEJBJarFiles();
        Archive clientJAR = null;
        int i = 0;
        while (i < ejbJARFiles.size()) {
            EJBJarFile ejbJarFile = (EJBJarFile)ejbJARFiles.get(i);
            clientJAR = J2EEProjectUtilities.getClientJAR(ejbJarFile, earFile);
            if (clientJAR != null) {
                if (ejbClientJARs == null) {
                    ejbClientJARs = new HashMap<EJBJarFile, Archive>();
                }
                ejbClientJARs.put(ejbJarFile, clientJAR);
            }
            ++i;
        }
        return ejbClientJARs == null ? Collections.EMPTY_MAP : ejbClientJARs;
    }

    public static void makeJ2EENatureFirst(IProject proj) {
        String natureID = J2EENature.getRegisteredRuntimeID(proj);
        if (natureID != null) {
            try {
                IProjectDescription description = proj.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length];
                newNatures[0] = natureID;
                int next = 1;
                int i = 0;
                while (i < prevNatures.length) {
                    if (!prevNatures[i].equals(natureID)) {
                        newNatures[next++] = prevNatures[i];
                    }
                    ++i;
                }
                description.setNatureIds(newNatures);
                proj.setDescription(description, null);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean hasProjectMapping(EARNatureRuntime runtime, IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 78->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String computeRelativeText(String referencingURI, String referencedURI, EnterpriseBean bean) {
        if (bean == null) {
            return null;
        }
        String beanName = bean.getName();
        if (beanName == null) {
            return null;
        }
        String relativeUri = J2EEProjectUtilities.computeRelativeText(referencingURI, referencedURI);
        if (relativeUri == null) {
            return beanName;
        }
        return String.valueOf(relativeUri) + "#" + beanName;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI) {
        if (referencingURI == null || referencedURI == null) {
            return null;
        }
        Path pPre = new Path(referencingURI);
        Path pDep = new Path(referencedURI);
        if (pPre.getDevice() != null || pDep.getDevice() != null) {
            return null;
        }
        pPre = pPre.makeRelative();
        pDep = pDep.makeRelative();
        while (pPre.segmentCount() > 1 && pDep.segmentCount() > 1 && pPre.segment(0).equals(pDep.segment(0))) {
            pPre = pPre.removeFirstSegments(1);
            pDep = pDep.removeFirstSegments(1);
        }
        Object result = null;
        StringBuffer buf = new StringBuffer();
        String segment = null;
        do {
            segment = pDep.lastSegment();
            pPre = pPre.removeLastSegments(1);
            pDep = pDep.removeLastSegments(1);
            if (segment != null) {
                result = result == null ? new Path(segment) : new Path(segment).append((IPath)result);
            }
            if (pPre.equals((Object)pDep) || pPre.isEmpty()) continue;
            buf.append("../");
        } while (!pPre.equals((Object)pDep));
        if (result != null) {
            buf.append(result.makeRelative().toString());
        }
        return buf.toString();
    }

    public static IProject getEJBProjectFromEJBClientProject(IProject ejbClientProject) {
        try {
            if (ejbClientProject != null && ejbClientProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IProject[] allProjects = J2EEProjectUtilities.getAllProjects();
                int i = 0;
                while (i < allProjects.length) {
                    if (EarModuleManager.getEJBModuleExtension().getEJBJar(allProjects[i]) != null && ejbClientProject == EarModuleManager.getEJBModuleExtension().getDefinedEJBClientJARProject(allProjects[i])) {
                        return allProjects[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static EnterpriseBean getEnterpriseBean(ICompilationUnit cu) {
        IProject proj = cu.getJavaProject().getProject();
        EJBJar jar = EarModuleManager.getEJBModuleExtension().getEJBJar(proj);
        if (jar == null) {
            jar = EarModuleManager.getEJBModuleExtension().getEJBJar(J2EEProjectUtilities.getEJBProjectFromEJBClientProject(proj));
        }
        if (jar != null) {
            int index = cu.getElementName().indexOf(46);
            String className = cu.getElementName();
            if (index > 0) {
                className = className.substring(0, index);
            }
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(cu.getParent().getElementName(), className, jar.eResource().getResourceSet());
            return jar.getEnterpriseBeanWithReference(javaClass);
        }
        return null;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        try {
            IPath sourcePath = J2EEProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
            if (sourcePath == null) {
                return null;
            }
            if (sourcePath.isEmpty()) {
                return p;
            }
            return p.getFolder(sourcePath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = J2EEProjectUtilities.createPath((IProject)p, (String)defaultSourceName);
        }
        boolean found = false;
        int i = 0;
        while (i < cp.length) {
            IPath sourceFolderPath;
            IFolder sourceFolder;
            if (cp[i].getEntryKind() == 3 && J2EEProjectUtilities.isSourceFolderAnInputContainer(sourceFolder = p.getFolder(sourceFolderPath = cp[i].getPath().removeFirstSegments(1)))) {
                found = true;
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (!found) {
            i = 0;
            while (i < cp.length) {
                if (cp[i].getEntryKind() == 3) {
                    if (firstSource == null) {
                        firstSource = cp[i];
                        if (defaultSourcePath == null) break;
                    }
                    if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                        return defaultSourcePath.removeFirstSegments(1);
                    }
                }
                ++i;
            }
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    public static boolean isSourceFolderAnInputContainer(IFolder sourceFolder) {
        IFolder parent = sourceFolder;
        do {
            if ((parent = parent.getParent()) != null) continue;
            return false;
        } while (!(parent instanceof IProject));
        IProject project = (IProject)parent;
        try {
            if (!project.isAccessible()) {
                return false;
            }
            IProjectDescription desc = project.getDescription();
            if (desc.hasNature("org.eclipse.jst.j2ee.ejb.EJBNature")) {
                return sourceFolder.findMember("META-INF/ejb-jar.xml") != null;
            }
            if (desc.hasNature("org.eclipse.jst.j2ee.ApplicationClientNature")) {
                return sourceFolder.findMember("META-INF/application-client.xml") != null;
            }
            if (desc.hasNature("org.eclipse.jst.j2ee.web.WebNature")) {
                return sourceFolder.findMember("WEB-INF/web.xml") != null;
            }
            if (desc.hasNature("org.eclipse.jst.j2ee.jca.ConnectorNature")) {
                return sourceFolder.findMember("META-INF/ra.xml") != null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }
}

