/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.internal.J2EEEditModel;
import org.eclipse.jst.j2ee.internal.common.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.project.J2EEResourceDependencyRegister;
import org.eclipse.jst.j2ee.internal.project.J2EEWorkbenchURIConverterImpl;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelNature;
import org.eclipse.wst.server.core.IModule;

public abstract class J2EENature
extends EditModelNature
implements ISynchronizerExtender {
    private EditModel cacheEditModel;
    protected IModule module;
    protected int moduleVersion;
    private static final String[] J2EE_NATURE_IDS = new String[]{"org.eclipse.jst.j2ee.ejb.EJBNature", "org.eclipse.jst.j2ee.EARNature", "org.eclipse.jst.j2ee.web.WebNature", "org.eclipse.jst.j2ee.ApplicationClientNature", "org.eclipse.jst.j2ee.jca.ConnectorNature"};

    public abstract String getOverlayIconName();

    protected abstract void createFolders() throws CoreException;

    protected J2EEWorkbenchURIConverterImpl getJ2EEWorkbenchURIConverter() {
        WorkbenchURIConverter conv = this.getWorkbenchURIConverter();
        if (conv instanceof J2EEWorkbenchURIConverterImpl) {
            return (J2EEWorkbenchURIConverterImpl)conv;
        }
        return null;
    }

    public IFolder getMetaFolder() {
        if (this.getMetaPath() != null) {
            return this.getProject().getFolder(this.getMetaPath());
        }
        return null;
    }

    protected IPath getMetaPath() {
        IContainer mofRoot = this.getEMFRoot();
        if (mofRoot == null) {
            return null;
        }
        return mofRoot.getProjectRelativePath().append(this.getMetaPathKey());
    }

    protected String getMetaPathKey() {
        return "META-INF";
    }

    public static J2EENature getRuntime(IProject project, String natureId) {
        if (project == null) {
            return null;
        }
        try {
            return (J2EENature)project.getNature(natureId);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static J2EENature getRuntime(IProject project, String[] possibleNatureIds) {
        if (project != null && project.isAccessible()) {
            int i = 0;
            while (i < possibleNatureIds.length) {
                J2EENature nature = J2EENature.getRuntime(project, possibleNatureIds[i]);
                if (nature != null) {
                    return nature;
                }
                ++i;
            }
        }
        return null;
    }

    public IContainer getModuleServerRoot() {
        return this.getProject();
    }

    protected J2EEWorkbenchURIConverterImpl initializeWorbenchURIConverter(ProjectResourceSet set) {
        return new J2EEWorkbenchURIConverterImpl(this, set.getSynchronizer());
    }

    public boolean isJ2EE1_3() {
        return this.getJ2EEVersion() >= 13;
    }

    public void primaryContributeToContext(EMFWorkbenchContextBase aNature) {
        if (this.emfContext == aNature) {
            return;
        }
        this.emfContext = aNature;
        this.getEmfContext().setDefaultToMOF5Compatibility(true);
        ProjectResourceSet set = aNature.getResourceSet();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        J2EEWorkbenchURIConverterImpl conv = this.initializeWorbenchURIConverter(set);
        set.setURIConverter((URIConverter)conv);
        this.initializeCacheEditModel();
        this.addAdapterFactories((ResourceSet)set);
        set.getSynchronizer().addExtender((ISynchronizerExtender)this);
        new J2EEResourceDependencyRegister(set);
    }

    public void secondaryContributeToContext(EMFWorkbenchContextBase aNature) {
        this.primaryContributeToContext(aNature);
    }

    protected void addAdapterFactories(ResourceSet aSet) {
    }

    public IModule getModule() {
        return this.module;
    }

    public void setModule(IModule module) {
        this.module = module;
    }

    public void replaceWith(J2EENature anotherNature) {
        if (anotherNature != null && anotherNature.getDeploymentDescriptorType() == this.getDeploymentDescriptorType()) {
            if (this.emfContext != null) {
                anotherNature.emfContext = this.emfContext;
                ResourceSetWorkbenchSynchronizer synchronizer = this.emfContext.getResourceSet().getSynchronizer();
                if (synchronizer != null) {
                    synchronizer.removeExtender((ISynchronizerExtender)this);
                    synchronizer.addExtender((ISynchronizerExtender)anotherNature);
                }
            }
            anotherNature.setCacheEditModel(this.cacheEditModel);
        }
    }

    public int getJ2EEVersion() {
        return 14;
    }

    public String getJ2EEVersionText() {
        switch (this.getJ2EEVersion()) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
        }
        return "1.4";
    }

    protected void primConfigure() throws CoreException {
        super.primConfigure();
        ProjectUtilities.addToBuildSpec((String)"org.eclipse.wst.validation.validationbuilder", (IProject)this.project);
    }

    public String getDeploymentDescriptorURI() {
        switch (this.getDeploymentDescriptorType()) {
            case 2: {
                return "META-INF/application.xml";
            }
            case 1: {
                return "META-INF/application-client.xml";
            }
            case 3: {
                return "META-INF/ejb-jar.xml";
            }
            case 5: {
                return "META-INF/ra.xml";
            }
            case 4: {
                return "WEB-INF/web.xml";
            }
        }
        return null;
    }

    public static J2EENature getRegisteredRuntime(IProject project) {
        return J2EENature.getRuntime(project, J2EE_NATURE_IDS);
    }

    public static String getRegisteredRuntimeID(IProject project) {
        String natureID = null;
        J2EENature nature = J2EENature.getRegisteredRuntime(project);
        if (nature != null) {
            natureID = nature.getNatureID();
        }
        return natureID;
    }

    public abstract Archive asArchive() throws OpenFailureException;

    public abstract Archive asArchive(boolean var1) throws OpenFailureException;

    public abstract int getDeploymentDescriptorType();

    public abstract EObject getDeploymentDescriptorRoot();

    public void setModuleVersion(int aModuleVersion) throws CoreException {
        if (aModuleVersion == this.moduleVersion) {
            return;
        }
        this.moduleVersion = aModuleVersion;
    }

    public int getModuleVersion() {
        this.moduleVersion = 22;
        return this.moduleVersion;
    }

    public String getModuleVersionText() {
        switch (this.getModuleVersion()) {
            case 10: {
                return "1.0";
            }
            case 11: {
                return "1.1";
            }
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
            case 15: {
                return "1.5";
            }
            case 20: {
                return "2.0";
            }
            case 21: {
                return "2.1";
            }
            case 22: {
                return "2.2";
            }
            case 23: {
                return "2.3";
            }
            case 24: {
                return "2.4";
            }
            case 25: {
                return "2.5";
            }
        }
        return "0.0";
    }

    protected abstract int getVersionFromModuleFile();

    protected void initializeCacheEditModel() {
        this.setCacheEditModel(this.createCacheEditModel());
    }

    protected abstract EditModel createCacheEditModel();

    protected void setCacheEditModel(EditModel newCacheEditModel) {
        this.cacheEditModel = newCacheEditModel;
    }

    protected EditModel getCacheEditModel() {
        if (this.emfContext == null) {
            this.getEmfContext();
        }
        return this.cacheEditModel;
    }

    public void projectChanged(IResourceDelta delta) {
    }

    public void projectClosed() {
        this.emfContext = null;
    }

    public abstract J2EEEditModel getJ2EEEditModelForRead(Object var1);

    public abstract J2EEEditModel getJ2EEEditModelForWrite(Object var1);

    public abstract String getEditModelKey();

    public static J2EEEditModel getEditModelForProject(IProject project, Object accessorKey) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        J2EEEditModel editModel = null;
        J2EENature nature = J2EENature.getRegisteredRuntime(project);
        if (nature != null) {
            editModel = nature.getJ2EEEditModelForRead(accessorKey);
        }
        return editModel;
    }
}

