/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.AddUtilityProjectToEARDataModel;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class J2EEUtilityJarListImportOperation
extends AbstractDataModelOperation {
    public J2EEUtilityJarListImportOperation(IDataModel operationDataModel) {
        super(operationDataModel);
    }

    public J2EEUtilityJarListImportOperation() {
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object[] utilityJars = (Object[])this.model.getProperty("J2EEUtilityJarListImportDataModel.UTILITY_JAR_LIST");
        if (utilityJars == null || utilityJars.length == 0) {
            return null;
        }
        monitor.beginTask(EARCreationResourceHandler.getString("J2EEUtilityJarListImportOperation_UI_0"), utilityJars.length);
        String earProject = this.model.getStringProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME");
        this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.BINARY_IMPORT");
        boolean isLinked = this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.LINK_IMPORT") || this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.CREATE_LINKED_PROJECT");
        boolean createProject = this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.CREATE_PROJECT") || this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.CREATE_LINKED_PROJECT");
        this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.OVERRIDE_PROJECT_ROOT");
        this.model.getStringProperty("J2EEUtilityJarListImportDataModel.PROJECT_ROOT");
        File utilityJar = null;
        IDataModel importModel = null;
        IWorkspace root = ResourcesPlugin.getWorkspace();
        int i = 0;
        while (i < utilityJars.length) {
            utilityJar = (File)utilityJars[i];
            monitor.subTask(String.valueOf(EARCreationResourceHandler.getString("J2EEUtilityJarListImportOperation_UI_1")) + utilityJar.getAbsolutePath());
            try {
                if (createProject) {
                    if (!isLinked) {
                        Archive archive = CommonarchiveFactory.eINSTANCE.primOpenArchive(utilityJar.getAbsolutePath());
                        importModel = DataModelFactory.createDataModel((IDataModelProvider)new J2EEUtilityJarImportDataModelProvider());
                        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", (Object)archive);
                        importModel.setProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME", (Object)earProject);
                        importModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), info);
                    } else {
                        this.createProjectWithLinkedJar(utilityJar, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    String utilityJarProjectName = importModel != null ? importModel.getStringProperty("IJ2EEArtifactImportDataModelProperties.PROJECT_NAME") : this.getUtilityJarProjectName(utilityJar);
                    IProject utilityJarProject = root.getRoot().getProject(utilityJarProjectName);
                    this.linkArchiveToEAR(earProject, utilityJar.getName(), utilityJarProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    importModel = null;
                } else {
                    IProject targetEARProject = root.getRoot().getProject(earProject);
                    if (!isLinked) {
                        this.createCopiedArchive(targetEARProject, utilityJar.getName(), utilityJar, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        this.createLinkedArchive(targetEARProject, utilityJar.getName(), utilityJar, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
            }
            catch (OpenFailureException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return OK_STATUS;
    }

    private String getUtilityJarProjectName(File utilityJar) {
        String name = null;
        if (utilityJar != null) {
            int len = utilityJar.getName().indexOf(46);
            name = utilityJar.getName().substring(0, len);
        }
        return name;
    }

    protected IPath getLinkedPath(File archiveFile) throws CoreException {
        String linkedPathVariable = this.model.getStringProperty("J2EEUtilityJarListImportDataModel.LINKED_PATH_VARIABLE");
        if (linkedPathVariable == null || linkedPathVariable.length() == 0) {
            return new Path(archiveFile.getAbsolutePath());
        }
        this.createLinkedPathVariableIfNecessary(linkedPathVariable, archiveFile.getParentFile());
        return new Path(linkedPathVariable).append(archiveFile.getName());
    }

    protected void createLinkedPathVariableIfNecessary(String linkedPathVariable, File archiveFile) throws CoreException {
        IPathVariableManager manager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        Path linkedPath = new Path(archiveFile.getAbsolutePath());
        manager.setValue(linkedPathVariable, (IPath)linkedPath);
    }

    protected void createProjectWithLinkedJar(File jarFile, IProgressMonitor monitor) throws CoreException {
        try {
            boolean overrideProjectRoot = this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.OVERRIDE_PROJECT_ROOT");
            String projectRoot = this.model.getStringProperty("J2EEUtilityJarListImportDataModel.PROJECT_ROOT");
            IWorkspace root = ResourcesPlugin.getWorkspace();
            IProject project = root.getRoot().getProject(this.getUtilityJarProjectName(jarFile));
            IProjectDescription description = null;
            if (project.exists()) {
                if (!project.isOpen()) {
                    return;
                }
                description = project.getDescription();
                ProjectUtilities.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature");
            } else {
                project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                description = root.newProjectDescription(project.getName());
                description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                if (overrideProjectRoot) {
                    description.setLocation((IPath)new Path(projectRoot));
                } else {
                    description.setLocation(null);
                }
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.createLinkedArchive(project, jarFile.getName(), jarFile, monitor);
            JemProjectUtilities.forceClasspathReload((IProject)project);
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.j2ee", 0, EARCreationResourceHandler.getString("J2EEUtilityJarListImportOperation_UI_2"), (Throwable)e));
        }
    }

    protected void createLinkedArchive(IProject project, String linkedFileName, File archiveFile, IProgressMonitor monitor) throws Exception {
        IFile linkedJarFile = null;
        IPath pathToArchive = this.getLinkedPath(archiveFile);
        boolean overwriteIfNecessary = this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.OVERWRITE_IF_NECESSARY");
        linkedJarFile = project.getFile(linkedFileName);
        if (linkedJarFile.exists()) {
            if (overwriteIfNecessary) {
                linkedJarFile.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                return;
            }
        }
        linkedJarFile.createLink(pathToArchive, 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            ClasspathEntry entry = new ClasspathEntry(2, 1, linkedJarFile.getFullPath(), ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, false, null, false, null);
            JemProjectUtilities.appendJavaClassPath((IProject)project, (IClasspathEntry)entry);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createCopiedArchive(IProject project, String jarFileName, File archiveFile, IProgressMonitor monitor) throws Exception {
        ByteArrayInputStream jarFileInputStream;
        block10: {
            Path pathToArchive = new Path(archiveFile.getAbsolutePath());
            boolean overwriteIfNecessary = this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.OVERWRITE_IF_NECESSARY");
            IFile copiedJarFile = project.getFile(jarFileName);
            if (copiedJarFile.exists()) {
                if (!overwriteIfNecessary) return;
                copiedJarFile.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            FileInputStream fileInputStream = null;
            ByteArrayOutputStream bos = null;
            jarFileInputStream = null;
            try {
                fileInputStream = new FileInputStream(pathToArchive.toOSString());
                bos = new ByteArrayOutputStream();
                byte[] data = new byte[4096];
                try {
                    int bytesRead = 0;
                    while (true) {
                        block11: {
                            if ((bytesRead = fileInputStream.read(data)) > 0) break block11;
                            data = null;
                            break;
                        }
                        bos.write(data, 0, bytesRead);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    fileInputStream.close();
                    throw throwable;
                }
                {
                    Object var13_16 = null;
                }
                fileInputStream.close();
                jarFileInputStream = new ByteArrayInputStream(bos.toByteArray());
                copiedJarFile.create((InputStream)jarFileInputStream, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    ClasspathEntry entry = new ClasspathEntry(2, 1, copiedJarFile.getFullPath(), ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, false, null, false, null);
                    JemProjectUtilities.appendJavaClassPath((IProject)project, (IClasspathEntry)entry);
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (bos != null) {
                    bos.close();
                }
                if (jarFileInputStream == null) throw throwable;
                jarFileInputStream.close();
                throw throwable;
            }
            {
                Object var15_19 = null;
                if (bos == null) break block10;
            }
            bos.close();
        }
        if (jarFileInputStream == null) return;
        jarFileInputStream.close();
    }

    public void linkArchiveToEAR(String earProjectName, String uriMapping, IProject utlityProject, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        AddUtilityProjectToEARDataModel addArchiveProjectToEARDataModel = AddUtilityProjectToEARDataModel.createAddToEARDataModel(earProjectName, utlityProject);
        addArchiveProjectToEARDataModel.setProperty("AddModuleToEARDataModel.URI", uriMapping);
        addArchiveProjectToEARDataModel.setBooleanProperty("AddModuleToEARDataModel.SYNC_TARGET_RUNTIME", true);
        addArchiveProjectToEARDataModel.getDefaultOperation().run(monitor);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

