/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.FlexibleProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.properties.IFlexibleProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProvider;

public class FlexibleProjectCreationDataModelProvider
extends AbstractDataModelProvider
implements IFlexibleProjectCreationDataModelProperties {
    public void init() {
        super.init();
        this.initNestedProjectModel();
    }

    protected void initNestedProjectModel() {
        IDataModel projModel = DataModelFactory.createDataModel((IDataModelProvider)new ProjectCreationDataModelProvider());
        this.model.addNestedModel("IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_PROJECT_CREATION", projModel);
    }

    public String[] getPropertyNames() {
        return new String[]{"IFlexibleProjectCreationDataModelProperties.PROJECT_NAME", "IFlexibleProjectCreationDataModelProperties.PROJECT_LOCATION", "IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_PROJECT_CREATION"};
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IFlexibleProjectCreationDataModelProperties.PROJECT_LOCATION".equals(propertyName)) {
            return this.getDefaultLocation();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean status = super.propertySet(propertyName, propertyValue);
        if ("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            IDataModel projModel = this.model.getNestedModel("IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_PROJECT_CREATION");
            projModel.setProperty("IProjectCreationProperties.PROJECT_NAME", propertyValue);
        } else if ("IFlexibleProjectCreationDataModelProperties.PROJECT_LOCATION".equals(propertyName)) {
            IDataModel projModel = this.model.getNestedModel("IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_PROJECT_CREATION");
            projModel.setProperty("IProjectCreationProperties.PROJECT_LOCATION", propertyValue);
        }
        return status;
    }

    public IStatus validate(String propertyName) {
        if ("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            return this.validateProjectName();
        }
        if ("IFlexibleProjectCreationDataModelProperties.PROJECT_LOCATION".equals(propertyName)) {
            return this.validateProjectLocation();
        }
        return OK_STATUS;
    }

    private IStatus validateProjectName() {
        IDataModel projModel = this.model.getNestedModel("IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_PROJECT_CREATION");
        return projModel.validateProperty("IProjectCreationProperties.PROJECT_NAME");
    }

    private IStatus validateProjectLocation() {
        IDataModel projModel = this.model.getNestedModel("IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_PROJECT_CREATION");
        return projModel.validateProperty("IProjectCreationProperties.PROJECT_LOCATION");
    }

    private String getDefaultLocation() {
        IPath path = this.getRootLocation();
        String projectName = (String)this.getProperty("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME");
        if (projectName != null) {
            path = path.append(projectName);
        }
        return path.toOSString();
    }

    private IPath getRootLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public IDataModelOperation getDefaultOperation() {
        return new FlexibleProjectCreationOperation(this.model);
    }
}

