/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ArchiveUtil {
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    public static final String DOT_SQLJ = ".sqlj";
    protected static boolean isRuntime = false;
    protected static boolean shouldUseTempDirectoryForRead = true;
    protected static String tempDirectoryName;
    protected static File tempDirectory;

    public static String classNameToJavaUri(String className) {
        return className.replace('.', '/').concat(DOT_JAVA);
    }

    public static String classNameToUri(String className) {
        return className.replace('.', '/').concat(DOT_CLASS);
    }

    public static String classUriToJavaUri(String classUri) {
        if (classUri == null || !classUri.endsWith(DOT_CLASS)) {
            return null;
        }
        String truncated = ArchiveUtil.truncateIgnoreCase(classUri, DOT_CLASS);
        StringTokenizer tok = new StringTokenizer(truncated, "$");
        return tok.nextToken().concat(DOT_JAVA);
    }

    public static String concatUri(String directoryname, String filename, char separator) {
        String uri = directoryname;
        if (!directoryname.endsWith(String.valueOf(separator)) && !filename.startsWith(String.valueOf(separator))) {
            uri = String.valueOf(uri) + separator;
        }
        return String.valueOf(uri) + filename;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!(in instanceof ZipInputStream)) {
                in.close();
            }
            if (out instanceof ZipOutputStream) throw throwable;
            out.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        if (!(in instanceof ZipInputStream)) {
            in.close();
        }
        if (out instanceof ZipOutputStream) return;
        out.close();
    }

    public static File createTempDirectory(String baseName, File parentDirectory) throws IOException {
        File tempFile = ArchiveUtil.createTempFile(baseName, parentDirectory);
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    public static File createTempFile(String baseName) throws IOException {
        return ArchiveUtil.createTempFile(baseName, ArchiveUtil.getTempDirectory());
    }

    public static File createTempFile(String baseName, File directory) throws IOException {
        String fileName = ArchiveUtil.getFileNameTail(baseName);
        if (fileName.length() < 3) {
            fileName = "WSTMP" + fileName;
        }
        File tempFile = File.createTempFile(fileName, null, directory);
        return tempFile;
    }

    public static boolean delete(File aFile) {
        if (aFile.isDirectory()) {
            File[] files = aFile.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!ArchiveUtil.delete(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return aFile.delete();
    }

    public static List getWriteProtectedFiles(File aFile, List aList) {
        if (aList == null) {
            aList = new ArrayList<File>();
        }
        if (aFile.exists() && !aFile.canWrite()) {
            aList.add(aFile);
        }
        if (aFile.isDirectory()) {
            File[] files = aFile.listFiles();
            int i = 0;
            while (i < files.length) {
                ArchiveUtil.getWriteProtectedFiles(files[i], aList);
                ++i;
            }
        }
        return aList;
    }

    public static String deriveEARRelativeURI(String classpathEntry, Archive anArchive) {
        return ArchiveUtil.deriveEARRelativeURI(classpathEntry, anArchive.getURI());
    }

    public static String deriveEARRelativeURI(String classpathEntry, String archiveUri) {
        try {
            String parent = ArchiveUtil.getFileNameParent(archiveUri);
            if (parent == null || parent.equals("")) {
                parent = ".";
            }
            String workingDir = new File(".").getCanonicalPath();
            String resolvedPath = new File(parent, classpathEntry).getCanonicalPath();
            if (!resolvedPath.startsWith(workingDir)) {
                return null;
            }
            if (resolvedPath.equals(workingDir)) {
                return null;
            }
            int start = workingDir.endsWith(File.separator) ? workingDir.length() : workingDir.length() + 1;
            return resolvedPath.substring(start, resolvedPath.length()).replace(File.separatorChar, '/');
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getFileNameExtension(String uri) {
        int index;
        if (uri != null && (index = uri.lastIndexOf(".")) != -1) {
            return uri.substring(index + 1);
        }
        return "";
    }

    public static String getFileNameParent(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return "";
        }
        if (lastIndex == 0) {
            return "/";
        }
        return uri.substring(0, lastIndex);
    }

    public static String getFileNameTail(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }

    public static ModuleFile getModuleFile(EObject ddObject) {
        Resource res = ddObject.eResource();
        if (res == null) {
            return null;
        }
        Archive archive = ArchiveUtil.getArchive(res);
        if (archive == null || !archive.isModuleFile()) {
            return null;
        }
        if (!(res instanceof XMLResource)) {
            return null;
        }
        XMLResource xmlRes = (XMLResource)res;
        if (xmlRes.isAlt()) {
            return ArchiveUtil.getModuleFileUsingAltDD((EARFile)archive, res);
        }
        return (ModuleFile)archive;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile ear, Resource res) {
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        Module m = ear.getDeploymentDescriptor().getModuleHavingAltDD(uri);
        if (m == null) {
            return null;
        }
        ModuleRef ref = ear.getModuleRef(m);
        if (ref == null) {
            return null;
        }
        return ref.getModuleFile();
    }

    public static String getModuleFileTypeName(int moduleType) {
        switch (moduleType) {
            case 2: {
                return CommonArchiveResourceHandler.getString("A_Application_file");
            }
            case 1: {
                return CommonArchiveResourceHandler.getString("An_Application_Client_JAR_file");
            }
            case 3: {
                return CommonArchiveResourceHandler.getString("An_EJB_JAR_file");
            }
            case 4: {
                return CommonArchiveResourceHandler.getString("A_WAR_file");
            }
            case 5: {
                return CommonArchiveResourceHandler.getString("A_RAR_file");
            }
        }
        return null;
    }

    public static Archive getArchive(Resource res) {
        if (res == null) {
            return null;
        }
        ResourceSet set = res.getResourceSet();
        if (set == null) {
            return null;
        }
        URIConverter conv = set.getURIConverter();
        if (conv == null || !(conv instanceof ArchiveURIConverterImpl)) {
            return null;
        }
        return ((ArchiveURIConverterImpl)conv).getArchive();
    }

    public static String getOSUri(String uri) {
        char sep = File.separatorChar;
        if (sep != '/') {
            return uri.replace('/', sep);
        }
        return uri.replace('\\', sep);
    }

    public static String getOSUri(String directoryname, String filename) {
        String osDirName = ArchiveUtil.getOSUri(directoryname);
        String osFileName = ArchiveUtil.getOSUri(filename);
        return ArchiveUtil.concatUri(osDirName, osFileName, File.separatorChar);
    }

    public static EObject getRoot(Resource aResource) throws EmptyResourceException {
        EList extent = aResource.getContents();
        if (extent.size() < 1) {
            throw new EmptyResourceException(aResource.getURI().toString());
        }
        return (EObject)extent.get(0);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String aString) {
        return ArchiveUtil.getTokens(aString, null);
    }

    public static String[] getTokens(String aString, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(aString) : new StringTokenizer(aString, delimiter);
        int size = tok.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size && tok.hasMoreTokens()) {
            tokens[i] = tok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String getValueIgnoreKeyCase(String key, Attributes attr) {
        Iterator<Map.Entry<Object, Object>> keysAndValues = attr.entrySet().iterator();
        while (keysAndValues.hasNext()) {
            Map.Entry<Object, Object> entry = keysAndValues.next();
            String entryKey = entry.getKey().toString();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static void inform(String message) {
        Logger.getLogger().logInfo(message);
    }

    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArchiveUtil.copy(in, out);
        return out.toByteArray();
    }

    public static boolean isJavaResource(Resource aResource) {
        return JavaURL.isJavaURL((String)aResource.getURI().toString());
    }

    public static boolean isRegisteredURIMapping(Resource res) {
        return URIMappingRegistryImpl.INSTANCE.getURI(res.getURI()) != res.getURI();
    }

    public static boolean isPlatformMetaResource(Resource res) {
        URI uri = res.getURI();
        return "platform".equals(uri.scheme()) && "meta".equals(uri.segment(0));
    }

    public static boolean isNullOrEmpty(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static boolean isRuntime() {
        return isRuntime;
    }

    public static boolean isValidDependency(Archive referencedJAR, Archive referencingJAR) {
        if (referencedJAR.isWARFile()) {
            return false;
        }
        if (referencedJAR == referencingJAR) {
            return false;
        }
        return referencingJAR.isApplicationClientFile() || !referencedJAR.isApplicationClientFile();
    }

    public static Properties loadProperties(Archive archive, String uri) throws FileNotFoundException, IOException {
        Properties properties;
        block2: {
            InputStream in = null;
            try {
                in = archive.getInputStream(uri);
                Properties p = new Properties();
                p.load(in);
                properties = p;
                Object var4_5 = null;
                if (in == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (in == null) break block3;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return properties;
    }

    public static void setIsRuntime(boolean aBoolean) {
        isRuntime = aBoolean;
    }

    public static void setShouldUseTempDirectoryForRead(boolean value) {
        shouldUseTempDirectoryForRead = value;
    }

    public static void setTempDirectory(File newTempDirectory) {
        tempDirectory = newTempDirectory;
        tempDirectoryName = newTempDirectory.getAbsolutePath();
    }

    public static void setTempDirectoryName(String newTempDirectoryName) throws ArchiveException {
        File dir = new File(newTempDirectoryName);
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                throw new ArchiveException(CommonArchiveResourceHandler.getString("make_temp_dir_EXC_", new Object[]{newTempDirectoryName}));
            }
            dir.deleteOnExit();
        }
        ArchiveUtil.setTempDirectory(dir);
    }

    public static boolean shouldUseTempDirectoryForRead() {
        return shouldUseTempDirectoryForRead;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL[] toLocalURLs(List entries, String uriRoot) {
        urls = new ArrayList<URL>();
        i = 0;
        while (true) {
            block16: {
                block17: {
                    block18: {
                        if (i >= entries.size()) {
                            urlArray = new URL[urls.size()];
                            return urls.toArray(urlArray);
                        }
                        pathEntry = (String)entries.get(i);
                        aFile = new File(pathEntry);
                        if (!aFile.isAbsolute()) {
                            pathEntry = ArchiveUtil.getOSUri(uriRoot, pathEntry);
                            aFile = new File(pathEntry);
                        }
                        if (!aFile.exists()) break block16;
                        if (!aFile.isDirectory()) break block18;
                        if (!pathEntry.endsWith(File.separator)) {
                            pathEntry = String.valueOf(pathEntry) + File.separatorChar;
                        }
                        break block17;
                    }
                    zip = null;
                    try {
                        try {
                            zip = new ZipFile(aFile);
                        }
                        catch (Exception v0) {
                            ArchiveUtil.inform(CommonArchiveResourceHandler.getString("invalid_classpath_WARN_", new Object[]{pathEntry}));
                            var7_8 = null;
                            if (zip != null) {
                                try {
                                    zip.close();
                                }
                                catch (IOException v1) {}
                            }
                            break block16;
                        }
                    }
                    catch (Throwable var8_9) {
                        var7_8 = null;
                        if (zip == null) throw var8_9;
                        try {}
                        catch (IOException v2) {}
                        zip.close();
                        throw var8_9;
                        throw var8_9;
                    }
                    {
                        var7_8 = null;
                        if (zip == null) break block17;
                    }
                    try {}
                    catch (IOException v3) {
                        ** GOTO lbl-1000
                    }
                    zip.close();
                }
                try lbl-1000:
                // 2 sources

                {
                    aFile = new File(pathEntry);
                    aUrl = aFile.toURL();
                    urls.add(aUrl);
                }
                catch (MalformedURLException v4) {
                    ArchiveUtil.inform(CommonArchiveResourceHandler.getString("invalid_cp_file_WARN_", new Object[]{pathEntry}));
                }
            }
            ++i;
        }
    }

    public static String truncateFromFrontIgnoreCase(String aString, String leadingSubString) {
        if (!aString.toLowerCase().startsWith(leadingSubString.toLowerCase())) {
            return aString;
        }
        return aString.substring(leadingSubString.length(), aString.length());
    }

    public static String truncateIgnoreCase(String aString, String trailingSubString) {
        int index = aString.toLowerCase().lastIndexOf(trailingSubString.toLowerCase());
        if (index != -1) {
            return aString.substring(0, index);
        }
        return aString;
    }

    public static String uriToClassName(String uri) {
        return ArchiveUtil.truncateIgnoreCase(uri.replace('/', '.'), DOT_CLASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        boolean bl;
        InputStream in;
        block16: {
            block15: {
                block14: {
                    if (moduleFile == null) {
                        return false;
                    }
                    if (moduleFile.isRARFile()) {
                        return true;
                    }
                    in = null;
                    String uri = moduleFile.getDeploymentDescriptorUri();
                    try {
                        try {
                            in = moduleFile.getInputStream(uri);
                            DocumentType docType = XmlDocumentReader.readDocumentType((InputStream)in, (String)uri);
                            if (docType == null) {
                                Object var5_4 = null;
                                break block14;
                            }
                            String[] ids = ArchiveUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
                            if (ids == null) {
                                break block15;
                            }
                            bl = ids[0].equals(docType.getPublicId()) && ids[1].equals(docType.getSystemId());
                            break block16;
                        }
                        catch (IOException iOException) {
                            Object var5_7 = null;
                            try {
                                if (in == null) return false;
                                in.close();
                                return false;
                            }
                            catch (IOException iOException2) {}
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        try {}
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                if (in == null) return false;
                in.close();
                return false;
            }
            Object var5_5 = null;
            try {}
            catch (IOException iOException) {}
            if (in == null) return false;
            in.close();
            return false;
        }
        Object var5_6 = null;
        try {}
        catch (IOException iOException) {}
        if (in == null) return bl;
        in.close();
        return bl;
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFastSpecVersion(ModuleFile moduleFile) {
        int n;
        InputStream in = null;
        String uri = moduleFile.getDeploymentDescriptorUri();
        try {
            try {
                in = moduleFile.getInputStream(uri);
                DocumentType docType = null;
                InputSource source = new InputSource(in);
                XmlDocumentReader aReader = new XmlDocumentReader(source);
                aReader.setValidate(false);
                Document aDocument = aReader.parseDocument();
                if (aDocument != null) {
                    docType = aDocument.getDoctype();
                }
                int version = -1;
                if (docType != null) {
                    String publicID = docType.getPublicId();
                    String systemID = docType.getSystemId();
                    if (publicID != null && systemID != null) {
                        version = ArchiveUtil.lookupVersion(moduleFile, publicID, systemID);
                    }
                }
                if (version == -1) {
                    NamedNodeMap map;
                    String schemaName = null;
                    String versionString = null;
                    if (aDocument != null && docType == null && (map = aDocument.getDocumentElement().getAttributes()) != null) {
                        Node versionNode;
                        Node schemaNode = map.getNamedItem("xsi:schemaLocation");
                        if (schemaNode != null) {
                            schemaName = schemaNode.getNodeValue();
                        }
                        if ((versionNode = map.getNamedItem("version")) != null) {
                            versionString = versionNode.getNodeValue();
                        }
                    }
                    if (schemaName != null) {
                        version = ArchiveUtil.lookupVersion(moduleFile, schemaName);
                    }
                    if (version == -1) {
                        version = ArchiveUtil.parseVersionString(moduleFile, versionString);
                    }
                }
                n = version;
                Object var13_14 = null;
            }
            catch (IOException iOException) {
                Object var13_15 = null;
                try {
                    if (in == null) return -1;
                    in.close();
                    return -1;
                }
                catch (IOException iOException2) {}
                return -1;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (in == null) return n;
        in.close();
        return n;
    }

    private static int parseVersionString(ModuleFile moduleFile, String versionAttr) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            version = versionAttr == null ? 14 : (versionAttr.equals("1.2") ? 12 : (versionAttr.equals("1.3") ? 13 : 14));
        } else if (moduleFile.isEJBJarFile()) {
            version = versionAttr == null ? 21 : (versionAttr.equals("1.1") ? 11 : (versionAttr.equals("2.0") ? 20 : 21));
        } else if (moduleFile.isApplicationClientFile()) {
            version = versionAttr == null ? 14 : (versionAttr.equals("1.2") ? 12 : (versionAttr.equals("1.3") ? 13 : 14));
        } else if (moduleFile.isWARFile()) {
            version = versionAttr == null ? 24 : (versionAttr.equals("2.2") ? 22 : (versionAttr.equals("2.3") ? 23 : 24));
        } else if (moduleFile.isRARFile()) {
            version = versionAttr == null ? 15 : (versionAttr.equals("1.0") ? 10 : 15);
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String schemaName) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                version = 21;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isWARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                version = 24;
            }
        } else if (moduleFile.isRARFile() && schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            version = 15;
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String publicID, String systemID) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && systemID.equals("http://java.sun.com/dtd/application_1_3.dtd") ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && systemID.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") ? 12 : 14);
        } else if (moduleFile.isEJBJarFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && systemID.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") ? 20 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") ? 11 : 21);
        } else if (moduleFile.isApplicationClientFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && systemID.equals("http://java.sun.com/dtd/application-client_1_3.dtd") ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") ? 12 : 14);
        } else if (moduleFile.isWARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd") ? 23 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") ? 22 : 24);
        } else if (moduleFile.isRARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && systemID.equals("http://java.sun.com/dtd/connector_1_0.dtd") ? 10 : 15;
        }
        return version;
    }
}

