/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ClientModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ConnectorModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WebModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ApplicationClientFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveCopyUtility;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ClientModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ConnectorModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBJarFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ReadOnlyDirectoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootArchiveTypeDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootEJBJarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WebModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.AppClient12ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear12ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.EjbJar11ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NullLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.RarImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ReadOnlyDirectoryLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.War22ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class CommonarchiveFactoryImpl
extends EFactoryImpl
implements CommonarchiveFactory {
    protected Map openArchives;
    private static boolean delegateNeedsInit = true;
    private CommonarchiveFactory delegate = null;

    static {
        CommonarchiveFactoryImpl.initPrereqs();
    }

    public CommonarchiveFactoryImpl() {
        this.initDelegate();
    }

    private void initDelegate() {
        if (delegateNeedsInit) {
            delegateNeedsInit = false;
            this.delegate = new CommonarchiveFactoryImpl(){

                public ApplicationClientFile createApplicationClientFile() {
                    return this.createApplicationClientFileGen();
                }

                public ClientModuleRef createClientModuleRef() {
                    return this.createClientModuleRefGen();
                }

                public ConnectorModuleRef createConnectorModuleRef() {
                    return this.createConnectorModuleRefGen();
                }

                public EARFile createEARFile() {
                    return this.createEARFileGen();
                }

                public EJBJarFile createEJBJarFile() {
                    return this.createEJBJarFileGen();
                }

                public EJBModuleRef createEJBModuleRef() {
                    return this.createEJBModuleRefGen();
                }

                public RARFile createRARFile() {
                    return this.createRARFileGen();
                }

                public WARFile createWARFile() {
                    return this.createWARFileGen();
                }

                public WebModuleRef createWebModuleRef() {
                    return this.createWebModuleRefGen();
                }
            };
        }
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createFile();
            }
            case 1: {
                return this.createArchive();
            }
            case 2: {
                return this.createEJBJarFile();
            }
            case 3: {
                return this.createWARFile();
            }
            case 4: {
                return this.createEARFile();
            }
            case 5: {
                return this.createApplicationClientFile();
            }
            case 8: {
                return this.createReadOnlyDirectory();
            }
            case 9: {
                return this.createRARFile();
            }
            case 11: {
                return this.createEJBModuleRef();
            }
            case 12: {
                return this.createWebModuleRef();
            }
            case 13: {
                return this.createClientModuleRef();
            }
            case 14: {
                return this.createConnectorModuleRef();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public void archiveClosed(Archive aClosedArchive) {
        this.getOpenArchives().remove(aClosedArchive);
    }

    public void archiveOpened(Archive anOpenArchive) {
        this.getOpenArchives().put(anOpenArchive, null);
    }

    public boolean canClose(Archive anArchive) {
        return !this.getOpenArchivesDependingOn(anArchive).isEmpty();
    }

    public void closeOpenArchives() {
        if (this.getOpenArchives().isEmpty()) {
            return;
        }
        ArrayList opened = new ArrayList(this.getOpenArchives().size());
        Iterator it = this.getOpenArchives().keySet().iterator();
        while (it.hasNext()) {
            opened.add(it.next());
        }
        int i = 0;
        while (i < opened.size()) {
            Archive anArchive = (Archive)opened.get(i);
            anArchive.close();
            ++i;
        }
    }

    public Archive copy(Archive anArchive) {
        return new ArchiveCopyUtility().copy(anArchive);
    }

    public ModuleFile copy(ModuleFile aModuleFile) {
        return new ArchiveCopyUtility().copy(aModuleFile);
    }

    public ApplicationClientFile createApplicationClientFileInitialized(String uri) {
        ApplicationClientFile clientFile = this.createApplicationClientFile();
        this.initializeNewApplicationClientFile(clientFile, uri);
        return clientFile;
    }

    public Archive createArchiveInitialized(String uri) {
        Archive anArchive = this.createArchive();
        this.initializeNewArchive(anArchive, uri);
        return anArchive;
    }

    public Archive createArchiveInitialized(ArchiveOptions options, String uri) {
        Archive anArchive = this.createArchive();
        this.initializeNewArchive(anArchive, uri, options);
        return anArchive;
    }

    public LoadStrategy createChildLoadStrategy(String uri, LoadStrategy parent) throws IOException, FileNotFoundException {
        LoadStrategy childStrategy = null;
        if (parent.isDirectory()) {
            String dirName = ((DirectoryArchiveLoadStrategy)parent).getDirectoryUri();
            String qualifiedUri = ArchiveUtil.getOSUri(dirName, uri);
            childStrategy = this.createLoadStrategy(qualifiedUri);
        } else {
            childStrategy = this.createNestedLoadStrategy(uri, parent);
        }
        return childStrategy;
    }

    public EARFile createEARFileInitialized(String uri) {
        EARFile earFile = this.createEARFile();
        this.initializeNewEARFile(earFile, uri);
        return earFile;
    }

    public EARFile createEARFileInitialized(ArchiveOptions options, String uri) {
        EARFile earFile = this.createEARFile();
        this.initializeNewEARFile(earFile, uri, options);
        return earFile;
    }

    public EJBJarFile createEJBJarFileInitialized(String uri) {
        EJBJarFile ejbJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(ejbJarFile, uri);
        return ejbJarFile;
    }

    public EJBJarFile createEJBJarFileInitialized(ArchiveOptions options, String uri) {
        EJBJarFile ejbJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(ejbJarFile, uri, options);
        return ejbJarFile;
    }

    public LoadStrategy createEmptyLoadStrategy() {
        return new NullLoadStrategyImpl();
    }

    public LoadStrategy createLoadStrategy(String uri) throws FileNotFoundException, IOException {
        String filename = uri.replace('/', java.io.File.separatorChar);
        java.io.File file = new java.io.File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString("file_not_found_EXC_", new Object[]{uri, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            return new DirectoryArchiveLoadStrategyImpl(uri);
        }
        return new ZipFileLoadStrategyImpl(file);
    }

    public LoadStrategy createNestedLoadStrategy(String uri, LoadStrategy parent) {
        LoadStrategy loadStrategy = null;
        ArchiveOptions options = ((Archive)parent.getContainer()).getOptions();
        if (!options.isReadOnly(uri)) {
            loadStrategy = this.createTempZipFileStrategyIfPossible(uri, parent);
        }
        if (loadStrategy == null) {
            return new NestedArchiveLoadStrategyImpl(parent);
        }
        return loadStrategy;
    }

    public RARFile createRARFileInitialized(String uri) {
        RARFile rarFile = this.createRARFile();
        this.initializeNewRARFile(rarFile, uri);
        return rarFile;
    }

    public LoadStrategy createTempZipFileStrategyIfPossible(String uri, LoadStrategy parent) {
        if (!ArchiveUtil.shouldUseTempDirectoryForRead()) {
            return null;
        }
        try {
            java.io.File tempFile = ArchiveUtil.createTempFile(uri);
            tempFile.deleteOnExit();
            InputStream in = parent.getInputStream(uri);
            FileOutputStream out = new FileOutputStream(tempFile);
            ArchiveUtil.copy(in, out);
            return new TempZipFileLoadStrategyImpl(tempFile);
        }
        catch (IOException ex) {
            ArchiveUtil.inform(String.valueOf(CommonArchiveResourceHandler.getString("make_temp_file_WARN_", new Object[]{uri})) + ex.getLocalizedMessage());
            return null;
        }
    }

    public WARFile createWARFileInitialized(String uri) {
        WARFile warFile = this.createWARFile();
        this.initializeNewWARFile(warFile, uri);
        return warFile;
    }

    protected ArchiveOptions defaultOptions(LoadStrategy aLoadStrategy) {
        ArchiveOptions options = new ArchiveOptions();
        options.setLoadStrategy(aLoadStrategy);
        return options;
    }

    public static CommonarchiveFactory getActiveFactory() {
        CommonarchivePackage pkg = CommonarchiveFactoryImpl.getPackage();
        if (pkg != null) {
            return pkg.getCommonarchiveFactory();
        }
        return null;
    }

    public String[] getManifestClassPathValues(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        String[] result = anArchive.getManifest().getClassPathTokenized();
        anArchive.close();
        return result;
    }

    public Map getOpenArchives() {
        if (this.openArchives == null) {
            this.openArchives = new WeakHashMap();
        }
        return this.openArchives;
    }

    public Set getOpenArchivesDependingOn(Archive anArchive) {
        HashSet<Archive> dependents = new HashSet<Archive>();
        Iterator opened = this.getOpenArchives().keySet().iterator();
        while (opened.hasNext()) {
            Archive openedArchive = (Archive)opened.next();
            if (openedArchive == anArchive || !openedArchive.isIndexed()) continue;
            EList files = openedArchive.getFiles();
            int i = 0;
            while (i < files.size()) {
                File aFile = (File)files.get(i);
                if (aFile.getLoadingContainer() == anArchive) {
                    Archive outermost = openedArchive;
                    Container c = openedArchive.getContainer();
                    while (c != null && c.isArchive()) {
                        outermost = (Archive)c;
                        c = c.getContainer();
                    }
                    dependents.add(outermost);
                }
                ++i;
            }
        }
        List nestedArchives = anArchive.getArchiveFiles();
        int i = 0;
        while (i < nestedArchives.size()) {
            dependents.addAll(this.getOpenArchivesDependingOn((Archive)nestedArchives.get(i)));
            ++i;
        }
        return dependents;
    }

    protected static void initPrereqs() {
        ArchiveInit.invokePrereqInits(true);
        ArchiveTypeDiscriminator disc = RootArchiveTypeDescriminatorImpl.singleton();
        disc.addChild(Ear12ImportStrategyImpl.getDiscriminator());
        disc.addChild(War22ImportStrategyImpl.getDiscriminator());
        disc.addChild(AppClient12ImportStrategyImpl.getDiscriminator());
        disc.addChild(RarImportStrategyImpl.getDiscriminator());
        disc.addChild(RootEJBJarDescriminatorImpl.singleton());
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewArchive(Archive anArchive, String uri) {
        anArchive.setURI(uri);
        anArchive.setSize(0L);
        anArchive.setLastModified(System.currentTimeMillis());
        anArchive.setDirectoryEntry(false);
        anArchive.setLoadStrategy(this.createEmptyLoadStrategy());
    }

    public void initializeNewEARFile(EARFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewEJBJarFile(EJBJarFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewModuleFile(ModuleFile anArchive, String uri) {
        this.initializeNewArchive(anArchive, uri);
        anArchive.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewWARFile(WARFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewArchive(Archive anArchive, String uri, ArchiveOptions options) {
        if (options.getLoadStrategy() == null) {
            try {
                options.setLoadStrategy(this.createEmptyLoadStrategy());
            }
            catch (Exception ex) {
                Logger.getLogger().logError((Throwable)ex);
            }
        }
        anArchive.setURI(uri);
        anArchive.setSize(0L);
        anArchive.setLastModified(System.currentTimeMillis());
        anArchive.setDirectoryEntry(false);
        anArchive.setLoadStrategy(options.getLoadStrategy());
        anArchive.setOptions(options);
    }

    public void initializeNewEARFile(EARFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewEJBJarFile(EJBJarFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewModuleFile(ModuleFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewArchive(anArchive, uri, options);
        anArchive.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewWARFile(WARFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public ApplicationClientFile openApplicationClientFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = AppClient12ImportStrategyImpl.getDiscriminator();
        return (ApplicationClientFile)this.openSpecificArchive(anArchive, disc);
    }

    public ApplicationClientFile openApplicationClientFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = AppClient12ImportStrategyImpl.getDiscriminator();
        return (ApplicationClientFile)this.openSpecificArchive(anArchive, disc);
    }

    public ApplicationClientFile openApplicationClientFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = AppClient12ImportStrategyImpl.getDiscriminator();
        return (ApplicationClientFile)this.openSpecificArchive(anArchive, disc);
    }

    public Archive openArchive(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String uri, String extraClassPath) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        anArchive.setExtraClasspath(extraClassPath);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public EARFile openEARFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = Ear12ImportStrategyImpl.getDiscriminator();
        return (EARFile)this.openSpecificArchive(anArchive, disc);
    }

    public EARFile openEARFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = Ear12ImportStrategyImpl.getDiscriminator();
        return (EARFile)this.openSpecificArchive(anArchive, disc);
    }

    public EARFile openEARFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = Ear12ImportStrategyImpl.getDiscriminator();
        return (EARFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJB11JarFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJB11JarFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJB11JarFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy aLoadStrategy, String uri, String extraClassPath) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        anArchive.setExtraClasspath(extraClassPath);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(String uri, String extraClassPath) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        anArchive.setExtraClasspath(extraClassPath);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public Archive openNestedArchive(LooseArchive loose, Archive parent) throws OpenFailureException {
        String uri = loose.getUri();
        try {
            LoadStrategy childStrategy = this.createLoadStrategy(loose.getBinariesPath());
            childStrategy.setLooseArchive(loose);
            ArchiveOptions options = parent.getOptions().cloneWith(childStrategy, loose.getUri());
            return this.primOpenArchive(options, uri);
        }
        catch (IOException ex) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString("open_nested_EXC_", new Object[]{uri, parent.getURI()}), ex);
        }
    }

    public Archive openNestedArchive(String uri, Archive parent) throws OpenFailureException {
        try {
            LoadStrategy childStrategy = this.createChildLoadStrategy(uri, parent.getLoadStrategy());
            ArchiveOptions options = parent.getOptions().cloneWith(childStrategy, uri);
            if (options.shouldDiscriminateNestedArchives()) {
                return this.openArchive(options, uri);
            }
            return this.primOpenArchive(options, uri);
        }
        catch (IOException ex) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString("open_nested_EXC_", new Object[]{uri, parent.getURI()}), ex);
        }
    }

    public RARFile openRARFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(anArchive, disc);
    }

    public RARFile openRARFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(anArchive, disc);
    }

    public RARFile openRARFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(anArchive, disc);
    }

    public ReadOnlyDirectory openReadOnlyDirectory(String uri) throws IOException {
        java.io.File aFile = new java.io.File(uri);
        if (!aFile.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString("could_not_find_dir_EXC_", new Object[]{uri}));
        }
        if (!aFile.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString("not_a_dir_EXC_", new Object[]{uri}));
        }
        ReadOnlyDirectoryLoadStrategyImpl strategy = new ReadOnlyDirectoryLoadStrategyImpl(uri);
        ReadOnlyDirectory container = this.createReadOnlyDirectory();
        container.setURI(uri);
        container.setLoadStrategy(strategy);
        container.setLastModified(aFile.lastModified());
        return container;
    }

    protected Archive openSpecificArchive(Archive anArchive, ArchiveTypeDiscriminator disc) throws OpenFailureException {
        if (!disc.canImport(anArchive)) {
            anArchive.close();
            throw new OpenFailureException(disc.getUnableToOpenMessage());
        }
        Archive specificArchive = disc.openArchive(anArchive);
        specificArchive.initializeAfterOpen();
        return specificArchive;
    }

    protected Archive openSpecificArchive(Archive anArchive, RootEJBJarDescriminatorImpl disc) throws OpenFailureException {
        Archive specific = this.openSpecificArchive(anArchive, (ArchiveTypeDiscriminator)disc);
        if (specific == anArchive) {
            anArchive.close();
            throw new OpenFailureException(disc.getUnableToOpenMessage());
        }
        return specific;
    }

    public WARFile openWARFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = War22ImportStrategyImpl.getDiscriminator();
        return (WARFile)this.openSpecificArchive(anArchive, disc);
    }

    public WARFile openWARFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = War22ImportStrategyImpl.getDiscriminator();
        return (WARFile)this.openSpecificArchive(anArchive, disc);
    }

    public WARFile openWARFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = War22ImportStrategyImpl.getDiscriminator();
        return (WARFile)this.openSpecificArchive(anArchive, disc);
    }

    public Archive primOpenArchive(ArchiveOptions options, String uri) throws OpenFailureException {
        if (options.getLoadStrategy() == null) {
            try {
                options.setLoadStrategy(this.createLoadStrategy(uri));
            }
            catch (IOException ex) {
                throw new OpenFailureException(CommonArchiveResourceHandler.getString("could_not_open_EXC_", new Object[]{uri}), ex);
            }
        }
        Archive anArchive = this.createArchive();
        anArchive.setURI(uri);
        anArchive.setOriginalURI(uri);
        anArchive.setLoadStrategy(options.getLoadStrategy());
        anArchive.setOptions(options);
        ArchiveTypeDiscriminatorRegistry.getInstance().contributeTypes(anArchive);
        return anArchive;
    }

    public Archive primOpenArchive(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        return this.primOpenArchive(this.defaultOptions(aLoadStrategy), uri);
    }

    public Archive primOpenArchive(String uri) throws OpenFailureException {
        return this.primOpenArchive(new ArchiveOptions(), uri);
    }

    protected void setOpenArchives(Map newOpenArchives) {
        this.openArchives = newOpenArchives;
    }

    public WARFile createWARFileGen() {
        WARFileImpl warFile = new WARFileImpl();
        return warFile;
    }

    public EJBJarFile createEJBJarFileGen() {
        EJBJarFileImpl ejbJarFile = new EJBJarFileImpl();
        return ejbJarFile;
    }

    public ApplicationClientFile createApplicationClientFileGen() {
        ApplicationClientFileImpl applicationClientFile = new ApplicationClientFileImpl();
        return applicationClientFile;
    }

    public EARFile createEARFileGen() {
        EARFileImpl earFile = new EARFileImpl();
        return earFile;
    }

    public RARFile createRARFileGen() {
        RARFileImpl rarFile = new RARFileImpl();
        return rarFile;
    }

    public File createFile() {
        FileImpl file = new FileImpl();
        return file;
    }

    public ReadOnlyDirectory createReadOnlyDirectory() {
        ReadOnlyDirectoryImpl readOnlyDirectory = new ReadOnlyDirectoryImpl();
        return readOnlyDirectory;
    }

    public CommonarchivePackage getCommonarchivePackage() {
        return (CommonarchivePackage)this.getEPackage();
    }

    public static CommonarchivePackage getPackage() {
        return CommonarchivePackage.eINSTANCE;
    }

    public EJBModuleRef createEJBModuleRefGen() {
        EJBModuleRefImpl ejbModuleRef = new EJBModuleRefImpl();
        return ejbModuleRef;
    }

    public WebModuleRef createWebModuleRefGen() {
        WebModuleRefImpl webModuleRef = new WebModuleRefImpl();
        return webModuleRef;
    }

    public ClientModuleRef createClientModuleRefGen() {
        ClientModuleRefImpl clientModuleRef = new ClientModuleRefImpl();
        return clientModuleRef;
    }

    public ConnectorModuleRef createConnectorModuleRefGen() {
        ConnectorModuleRefImpl connectorModuleRef = new ConnectorModuleRefImpl();
        return connectorModuleRef;
    }

    public ClientModuleRef createClientModuleRef(ApplicationClientFile clientFile) {
        ClientModuleRef ref = this.createClientModuleRef();
        ref.setModuleFile(clientFile);
        return ref;
    }

    public ConnectorModuleRef createConnectorModuleRef(RARFile rarFile) {
        ConnectorModuleRef ref = this.createConnectorModuleRef();
        ref.setModuleFile(rarFile);
        return ref;
    }

    public EJBModuleRef createEJBModuleRef(EJBJarFile ejbJarFile) {
        EJBModuleRef ref = this.createEJBModuleRef();
        ref.setModuleFile(ejbJarFile);
        return ref;
    }

    public WebModuleRef createWebModuleRef(WARFile warFile) {
        WebModuleRef ref = this.createWebModuleRef();
        ref.setModuleFile(warFile);
        return ref;
    }

    public Archive createArchive() {
        ArchiveImpl archive = new ArchiveImpl();
        return archive;
    }

    public ApplicationClientFile createApplicationClientFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createApplicationClientFile();
    }

    public ClientModuleRef createClientModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createClientModuleRef();
    }

    public ConnectorModuleRef createConnectorModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createConnectorModuleRef();
    }

    public EARFile createEARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEARFile();
    }

    public EJBJarFile createEJBJarFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEJBJarFile();
    }

    public EJBModuleRef createEJBModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEJBModuleRef();
    }

    public RARFile createRARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createRARFile();
    }

    public WARFile createWARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createWARFile();
    }

    public WebModuleRef createWebModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createWebModuleRef();
    }

    public CommonarchiveFactory getDelegate() {
        return this.delegate;
    }
}

