/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.MessageLimitException;

public final class WorkbenchReporter
implements IReporter {
    public static final String DEFAULT_LOCATION = "";
    public static final int NO_MESSAGE_LIMIT = -1;
    private IProject _project = null;
    private IProgressMonitor _monitor = null;

    public static void addMessage(IResource resource, Class messageOwner, IMessage message) {
        WorkbenchReporter.addMessage(resource, messageOwner, null, message);
    }

    public static void addMessage(IResource resource, Class messageOwner, ClassLoader cl, IMessage message) {
        WorkbenchReporter.addMessage(resource, messageOwner, cl, message, null, DEFAULT_LOCATION);
    }

    public static void addMessage(IResource resource, Class clazz, IMessage message, String targetObjectName, String location) {
        WorkbenchReporter.addMessage(resource, clazz, null, message, targetObjectName, location);
    }

    public static void addMessage(IResource resource, Class clazz, IMessage message, String targetObjectName, String location, String markerId) {
        WorkbenchReporter.addMessage(resource, clazz, null, message, targetObjectName, location, markerId);
    }

    public static void addMessage(IResource resource, Class clazz, ClassLoader cl, IMessage message, String targetObjectName, String location) {
        if (clazz == null || message == null || resource == null) {
            return;
        }
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        WorkbenchReporter.addMessage(resource, WorkbenchReporter.getUniqueId(clazz), cl, message, targetObjectName, location);
    }

    public static void addMessage(IResource resource, Class clazz, ClassLoader cl, IMessage message, String targetObjectName, String location, String markerId) {
        if (clazz == null || message == null || resource == null) {
            return;
        }
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        WorkbenchReporter.addMessage(resource, WorkbenchReporter.getUniqueId(clazz), cl, message, targetObjectName, location, markerId);
    }

    public static void addMessage(IResource resource, String messageOwnerId, ClassLoader cl, IMessage message) {
        WorkbenchReporter.addMessage(resource, messageOwnerId, cl, message, null, DEFAULT_LOCATION);
    }

    public static void addMessage(IResource resource, String messageOwnerId, ClassLoader cl, IMessage message, String targetObjectName, String location) {
        block2: {
            int severity = message.getSeverity();
            try {
                TaskListUtility.addTask(messageOwnerId, resource, location, message.getId(), message.getText(cl), severity, targetObjectName, message.getGroupName(), message.getOffset(), message.getLength());
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.addMessage(Class,, IResource, IMessage, String, String");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void addMessage(IResource resource, String messageOwnerId, ClassLoader cl, IMessage message, String targetObjectName, String location, String markerId) {
        block2: {
            int severity = message.getSeverity();
            try {
                TaskListUtility.addTask(messageOwnerId, resource, location, message.getId(), message.getText(cl), severity, markerId, targetObjectName, message.getGroupName(), message.getOffset(), message.getLength());
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.addMessage(Class,, IResource, IMessage, String, String");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void removeAllMessages(IResource resource, IValidator validator) {
        block4: {
            if (resource == null) {
                return;
            }
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
            if (vmd == null) {
                return;
            }
            String[] validatorNames = vmd.getValidatorNames();
            try {
                TaskListUtility.removeAllTasks(resource, validatorNames);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.removeAllMessages(String[], IResource, String)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void removeAllMessages(IResource resource, IValidator validator, Object object) {
        block4: {
            if (resource == null) {
                return;
            }
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
            if (vmd == null) {
                return;
            }
            String[] validatorNames = vmd.getValidatorNames();
            try {
                String targetObjectName = WorkbenchReporter.getTargetObjectName(vmd.getHelper(resource.getProject()), object);
                WorkbenchReporter.removeAllMessages(resource, validatorNames, targetObjectName);
            }
            catch (InstantiationException exc) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter::removeAllMessages(IResource, IValidator, Object)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void removeAllMessages(IResource resource, String[] validatorNames, String targetObjectName) {
        block2: {
            try {
                TaskListUtility.removeAllTasks(resource, validatorNames, targetObjectName);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.removeAllMessages(String[], IResource, String)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void removeMessageSubset(IResource resource, Class messageOwner, String groupName) {
        WorkbenchReporter.removeMessageSubset(resource, new String[]{WorkbenchReporter.getUniqueId(messageOwner)}, null, groupName);
    }

    public static void removeMessageSubset(IResource resource, String messageOwnerId, String groupName) {
        WorkbenchReporter.removeMessageSubset(resource, new String[]{messageOwnerId}, null, groupName);
    }

    public static void removeMessageSubset(IResource resource, String[] ownerId, String targetObjectName, String groupName) {
        block2: {
            try {
                TaskListUtility.removeTaskSubset(resource, ownerId, targetObjectName, groupName);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.removeMessageSubset(String[], IResource, String, String)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static String getUniqueId(Class clazz) {
        if (clazz == null) {
            return DEFAULT_LOCATION;
        }
        return clazz.getName().intern();
    }

    public static String getUniqueId(IValidator validator) {
        if (validator == null) {
            return DEFAULT_LOCATION;
        }
        return WorkbenchReporter.getUniqueId(validator.getClass());
    }

    public static Logger getMsgLogger(IValidator validator) {
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return ValidationPlugin.getPlugin().getMsgLogger();
        }
        return vmd.getMsgLogger();
    }

    public static String getLocation(IWorkbenchContext helper, IMessage message) {
        if (message == null) {
            return WorkbenchReporter.getLocationText(helper, null);
        }
        int lineNo = message.getLineNumber();
        if (lineNo == 0) {
            return WorkbenchReporter.getLocationText(helper, message.getTargetObject());
        }
        return String.valueOf(lineNo);
    }

    public static String getLocationText(IWorkbenchContext helper, Object targetObject) {
        String location;
        block3: {
            location = null;
            try {
                location = helper.getLocation(targetObject);
            }
            catch (Throwable exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.getLocationText(Object)");
                entry.setTargetException(exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        if (location == null || location.trim().equals(DEFAULT_LOCATION)) {
            location = DEFAULT_LOCATION;
        }
        return location;
    }

    protected static void addTerminatedTask(IProject project, IValidator validator) throws IllegalArgumentException {
        if (project == null || validator == null) {
            return;
        }
        ValidatorManager.getManager().addMessageLimitExceeded(project);
    }

    protected static String getTargetObjectName(IWorkbenchContext helper, IMessage message) {
        if (message == null) {
            return WorkbenchReporter.getTargetObjectName(helper, null);
        }
        return WorkbenchReporter.getTargetObjectName(helper, message.getTargetObject());
    }

    private static String getTargetObjectName(IWorkbenchContext helper, Object targetObject) {
        String targetObjectName;
        block2: {
            targetObjectName = null;
            try {
                targetObjectName = helper.getTargetObjectName(targetObject);
            }
            catch (Throwable exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.getTargetObjectName(Object)");
                entry.setTargetException(exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        return targetObjectName;
    }

    protected static ValidatorMetaData getVMD(IValidator validator) throws IllegalArgumentException {
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        return vmd;
    }

    public WorkbenchReporter(IWorkbenchContext helper, IProgressMonitor monitor, IProject project) {
        this(project, monitor);
    }

    public WorkbenchReporter(IProject project, IProgressMonitor monitor) {
        this._project = project;
        this._monitor = monitor;
    }

    protected IWorkbenchContext getHelper(IValidator validator) throws InstantiationException, IllegalArgumentException {
        ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
        IWorkbenchContext helper = vmd.getHelper(this.getProject());
        return helper;
    }

    public IProject getProject() {
        return this._project;
    }

    public IProgressMonitor getProgressMonitor() {
        return this._monitor;
    }

    private IResource getDefaultResource() {
        IProject prj = this.getProject();
        if (prj != null) {
            return prj;
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getMessageResource(IValidator validator, Object object) {
        IResource resource;
        block17: {
            if (validator == null) {
                return null;
            }
            resource = null;
            if (object != null) {
                if (object instanceof IResource) {
                    resource = (IResource)object;
                } else if (object instanceof WorkbenchFileDelta) {
                    resource = ((WorkbenchFileDelta)((Object)object)).getResource();
                }
                if (resource == null) {
                    try {
                        IWorkbenchContext helper = this.getHelper(validator);
                        resource = helper.getResource(object);
                    }
                    catch (InstantiationException exc) {
                        try {
                            ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
                            ValidationRegistryReader.getReader().disableValidator(vmd);
                            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("WorkbenchReporter::getMessageResource(IValidator, Object)");
                                entry.setTargetException((Throwable)exc);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                        }
                        catch (IllegalArgumentException exc2) {
                            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("WorkbenchReporter::getMessageResource(IValidator, Object)");
                                entry.setTargetException((Throwable)exc2);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                        }
                    }
                    catch (IllegalArgumentException exc) {
                        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("WorkbenchReporter::getMessageResource(IValidator, Object)");
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                    }
                    catch (Throwable exc) {
                        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                        if (!logger.isLoggingLevel(Level.SEVERE)) break block17;
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("WorkbenchReporter.getMessageResource(IValidator, Object)");
                        entry.setTargetException(exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                }
            }
        }
        if (resource == null) {
            resource = this.getDefaultResource();
        }
        if (!resource.exists()) {
            resource = this.getDefaultResource();
        }
        return resource;
    }

    public void displaySubtask(String message) {
        if (message == null || message.equals(DEFAULT_LOCATION)) {
            return;
        }
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().subTask(message);
        } else {
            System.out.println(message);
        }
    }

    public List getMessages() {
        return null;
    }

    public boolean isCancelled() {
        if (this.getProgressMonitor() != null) {
            return this.getProgressMonitor().isCanceled();
        }
        return false;
    }

    public void addMessage(IValidator validator, IMessage message) throws MessageLimitException {
        IResource resource = this.getMessageResource(validator, message.getTargetObject());
        IWorkbenchContext helper = null;
        ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
        try {
            helper = this.getHelper(validator);
        }
        catch (InstantiationException exc) {
            try {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("WorkbenchReporter::addMessage(IValidator, IMessage)");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
                return;
            }
            catch (IllegalArgumentException exc2) {
                this.logDisabledValidator(exc2);
                return;
            }
        }
        catch (IllegalArgumentException exc) {
            this.logDisabledValidator(exc);
            return;
        }
        if (resource == null) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.FINE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter.addMessage(IValidator, Message)");
                entry.setMessageTypeIdentifier("VBF_EXC_INVALID_RESOURCE");
                entry.setTokens(new String[]{message.getText(), WorkbenchReporter.getTargetObjectName(helper, message)});
                logger.write(Level.FINE, (Object)entry);
            }
            return;
        }
        ValidatorManager mgr = ValidatorManager.getManager();
        if (mgr.isMessageLimitExceeded((IResource)resource.getProject())) {
            this.validateMessageLimitExceeded(validator, resource);
        }
        WorkbenchReporter.addMessage(resource, validator.getClass(), message, WorkbenchReporter.getTargetObjectName(helper, message), WorkbenchReporter.getLocation(helper, message), vmd.getMarkerId());
    }

    private void logDisabledValidator(IllegalArgumentException exc) {
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("WorkbenchReporter::addMessage(IValidator, IMessage)");
            entry.setTargetException((Throwable)exc);
            logger.write(Level.SEVERE, (Object)entry);
        }
    }

    private void validateMessageLimitExceeded(IValidator validator, IResource resource) {
        block2: {
            try {
                WorkbenchReporter.addTerminatedTask(resource.getProject(), validator);
            }
            catch (IllegalArgumentException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter::addMessage(IValidator, IMessage)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        throw new MessageLimitException();
    }

    public void displaySubtask(IValidator validator, IMessage message) {
        if (message == null || message.equals(DEFAULT_LOCATION)) {
            return;
        }
        this.displaySubtask(message.getText(validator.getClass().getClassLoader()));
    }

    public void removeAllMessages(IValidator validator) {
        if (validator == null) {
            return;
        }
        this.removeAllMessages(validator, null);
    }

    public void removeAllMessages(IValidator validator, Object object) {
        IResource resource = this.getMessageResource(validator, object);
        if (resource == null) {
            return;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return;
        }
        IWorkbenchContext helper = null;
        try {
            helper = vmd.getHelper(resource.getProject());
        }
        catch (InstantiationException exc) {
            ValidationRegistryReader.getReader().disableValidator(vmd);
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter::removeAllMessages(IResource, IValidator, Object)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
        String[] validatorNames = vmd.getValidatorNames();
        String targetObjectName = WorkbenchReporter.getTargetObjectName(helper, object);
        WorkbenchReporter.removeAllMessages(resource, validatorNames, targetObjectName);
    }

    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        IResource resource = this.getMessageResource(validator, obj);
        if (resource == null) {
            return;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return;
        }
        IWorkbenchContext helper = null;
        try {
            helper = vmd.getHelper(resource.getProject());
        }
        catch (InstantiationException exc) {
            ValidationRegistryReader.getReader().disableValidator(vmd);
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchReporter::removeAllMessages(IResource, IValidator, Object)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
        String[] validatorNames = vmd.getValidatorNames();
        String targetObjectName = WorkbenchReporter.getTargetObjectName(helper, obj);
        WorkbenchReporter.removeMessageSubset(resource, validatorNames, targetObjectName, groupName);
    }
}

