/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexFinal;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDIdentityConstraintCategory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDProhibitedSubstitutions;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.XSDXPathVariety;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDUtil;
import org.w3c.dom.Element;

public class XSDPrototypicalSchema {
    protected static XSDPrototypicalSchema instance;
    public XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    public XSDSchema prototypeSchema;
    public XSDSchema purchaseOrderSchema = this.initializePurchaseOrderSchema();
    protected String someOtherSchemaURI = "http://www.example.com/SomeOtherSchema";

    public static XSDPrototypicalSchema getInstance() {
        if (instance == null) {
            instance = new XSDPrototypicalSchema();
        }
        return instance;
    }

    public static XSDSchema getPrototypicalSchema() {
        return XSDPrototypicalSchema.getInstance().prototypeSchema;
    }

    public static XSDSchema getPurchaseOrderSchema() {
        return XSDPrototypicalSchema.getInstance().purchaseOrderSchema;
    }

    public XSDPrototypicalSchema() {
        this.initializePrototypeSchema();
    }

    public XSDSchema initializePrototypeSchema() {
        this.prototypeSchema = this.xsdFactory.createXSDSchema();
        this.prototypeSchema.setTargetNamespace("http://www.example.com/PrototypicalSchema");
        this.prototypeSchema.setElementFormDefault(XSDForm.QUALIFIED_LITERAL);
        this.prototypeSchema.setAttributeFormDefault(XSDForm.QUALIFIED_LITERAL);
        this.prototypeSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map<String, String> qNamePrefixToNamespaceMap = this.prototypeSchema.getQNamePrefixToNamespaceMap();
        qNamePrefixToNamespaceMap.put("PTS", this.prototypeSchema.getTargetNamespace());
        qNamePrefixToNamespaceMap.put(this.prototypeSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        qNamePrefixToNamespaceMap.put("EXT", this.someOtherSchemaURI);
        this.initializeSomeOtherImport();
        this.initializeSimpleAttributeGroupDefinition();
        this.initializeSimpleRecursiveModelGroupDefinition();
        this.initializeSimpleRecursiveComplexTypeDefinition();
        this.initializeSimpleRecursiveElementDeclaration();
        this.initializeSimpleAttributeDeclaration();
        this.initializeSimpleElementDeclarationWithAnonymousType();
        this.initializeSimpleTypeDefinition();
        this.initializeSimpleListTypeDefinition();
        this.initializeSimpleUnionTypeDefinition();
        this.initializeFancyListTypeDefinition();
        this.initializeSimpleContentComplexTypeDefinition();
        return this.prototypeSchema;
    }

    public void initializeSomeOtherImport() {
        XSDImport someOtherImport = this.xsdFactory.createXSDImport();
        someOtherImport.setNamespace(this.someOtherSchemaURI);
        someOtherImport.setSchemaLocation(this.someOtherSchemaURI);
        this.prototypeSchema.getContents().add((Object)someOtherImport);
    }

    public void initializeSimpleAttributeGroupDefinition() {
        XSDAttributeGroupDefinition simpleAttributeGroupDefinition = this.xsdFactory.createXSDAttributeGroupDefinition();
        simpleAttributeGroupDefinition.setName("simpleAttributeGroupDefinition");
        XSDAttributeDeclaration simpleAttributeDeclarationGroupMember = this.xsdFactory.createXSDAttributeDeclaration();
        simpleAttributeDeclarationGroupMember.setName("simpleAttributeDeclarationGroupMember");
        simpleAttributeDeclarationGroupMember.setTypeDefinition(this.prototypeSchema.resolveSimpleTypeDefinition(this.someOtherSchemaURI, "someOtherTypeDefinition"));
        XSDAttributeUse simpleAttributeUseGroupMember = this.xsdFactory.createXSDAttributeUse();
        simpleAttributeUseGroupMember.setContent(simpleAttributeDeclarationGroupMember);
        simpleAttributeUseGroupMember.setConstraint(XSDConstraint.DEFAULT_LITERAL);
        simpleAttributeUseGroupMember.setLexicalValue("defaultValue");
        simpleAttributeGroupDefinition.getContents().add((Object)simpleAttributeUseGroupMember);
        this.prototypeSchema.getContents().add((Object)simpleAttributeGroupDefinition);
    }

    public void initializeSimpleRecursiveModelGroupDefinition() {
        XSDModelGroupDefinition simpleRecursiveModelGroupDefinition = this.xsdFactory.createXSDModelGroupDefinition();
        simpleRecursiveModelGroupDefinition.setName("simpleRecursiveModelGroupDefinition");
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleRecursiveModelGroupDefinition.setAnnotation(annotation);
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDElementDeclaration simpleRecursiveElementDeclarationReference = this.xsdFactory.createXSDElementDeclaration();
        simpleRecursiveElementDeclarationReference.setResolvedElementDeclaration(this.prototypeSchema.resolveElementDeclaration("simpleRecursiveElementDeclaration"));
        XSDParticle simpleRecursiveElementParticle = this.xsdFactory.createXSDParticle();
        simpleRecursiveElementParticle.setContent(simpleRecursiveElementDeclarationReference);
        simpleRecursiveElementParticle.setMinOccurs(0);
        simpleRecursiveElementParticle.setMaxOccurs(-1);
        modelGroup.getContents().add((Object)simpleRecursiveElementParticle);
        XSDWildcard elementWildcard = this.xsdFactory.createXSDWildcard();
        elementWildcard.getLexicalNamespaceConstraint().add((Object)"##other");
        elementWildcard.setProcessContents(XSDProcessContents.LAX_LITERAL);
        XSDParticle wildcardParticle = this.xsdFactory.createXSDParticle();
        wildcardParticle.setContent(elementWildcard);
        modelGroup.getContents().add((Object)wildcardParticle);
        simpleRecursiveModelGroupDefinition.setModelGroup(modelGroup);
        this.prototypeSchema.getContents().add((Object)simpleRecursiveModelGroupDefinition);
    }

    public void initializeSimpleRecursiveComplexTypeDefinition() {
        XSDComplexTypeDefinition simpleRecursiveComplexTypeDefinition = this.xsdFactory.createXSDComplexTypeDefinition();
        simpleRecursiveComplexTypeDefinition.setName("SimpleRecursiveComplexTypeDefinition");
        simpleRecursiveComplexTypeDefinition.setAbstract(false);
        simpleRecursiveComplexTypeDefinition.getBlock().add((Object)XSDProhibitedSubstitutions.ALL_LITERAL);
        simpleRecursiveComplexTypeDefinition.getLexicalFinal().add((Object)XSDComplexFinal.ALL_LITERAL);
        simpleRecursiveComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.RESTRICTION_LITERAL);
        simpleRecursiveComplexTypeDefinition.setMixed(true);
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleRecursiveComplexTypeDefinition.setAnnotation(annotation);
        XSDModelGroupDefinition simpleRecursiveModelGroupDefinitionReference = this.xsdFactory.createXSDModelGroupDefinition();
        simpleRecursiveModelGroupDefinitionReference.setResolvedModelGroupDefinition(this.prototypeSchema.resolveModelGroupDefinition("simpleRecursiveModelGroupDefinition"));
        XSDParticle modelGroupParticle = this.xsdFactory.createXSDParticle();
        modelGroupParticle.setContent(simpleRecursiveModelGroupDefinitionReference);
        simpleRecursiveComplexTypeDefinition.setContent(modelGroupParticle);
        XSDAttributeDeclaration simpleAttributeDeclarationReference = this.xsdFactory.createXSDAttributeDeclaration();
        simpleAttributeDeclarationReference.setResolvedAttributeDeclaration(this.prototypeSchema.resolveAttributeDeclaration("simpleAttributeDeclaration"));
        XSDAttributeUse simpleAttributeUse = this.xsdFactory.createXSDAttributeUse();
        simpleAttributeUse.setContent(simpleAttributeDeclarationReference);
        simpleAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        simpleRecursiveComplexTypeDefinition.getAttributeContents().add((Object)simpleAttributeUse);
        XSDAttributeGroupDefinition simpleAttributeGroupDefinitionReference = this.xsdFactory.createXSDAttributeGroupDefinition();
        simpleAttributeGroupDefinitionReference.setResolvedAttributeGroupDefinition(this.prototypeSchema.resolveAttributeGroupDefinition("simpleAttributeGroupDefinition"));
        simpleRecursiveComplexTypeDefinition.getAttributeContents().add((Object)simpleAttributeGroupDefinitionReference);
        XSDWildcard attributeWildcard = this.xsdFactory.createXSDWildcard();
        attributeWildcard.getLexicalNamespaceConstraint().add((Object)"##other");
        simpleRecursiveComplexTypeDefinition.setAttributeWildcardContent(attributeWildcard);
        this.prototypeSchema.getContents().add((Object)simpleRecursiveComplexTypeDefinition);
        Element appinfo = annotation.createApplicationInformation("http://www.example.com/appinfo");
        annotation.getElement().appendChild(appinfo);
        Element documentation = annotation.createUserInformation("http://www.example.com/documentation");
        annotation.getElement().appendChild(documentation);
        documentation.appendChild(documentation.getOwnerDocument().createTextNode("A simple recursive complex type definition."));
    }

    public void initializeSimpleRecursiveElementDeclaration() {
        XSDElementDeclaration simpleRecursiveElementDeclaration = this.xsdFactory.createXSDElementDeclaration();
        simpleRecursiveElementDeclaration.setName("simpleRecursiveElementDeclaration");
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleRecursiveElementDeclaration.setAnnotation(annotation);
        simpleRecursiveElementDeclaration.setTypeDefinition(this.prototypeSchema.resolveComplexTypeDefinition("SimpleRecursiveComplexTypeDefinition"));
        XSDIdentityConstraintDefinition unique = this.xsdFactory.createXSDIdentityConstraintDefinition();
        unique.setIdentityConstraintCategory(XSDIdentityConstraintCategory.UNIQUE_LITERAL);
        unique.setName("unique");
        XSDXPathDefinition uniqueSelector = this.xsdFactory.createXSDXPathDefinition();
        uniqueSelector.setVariety(XSDXPathVariety.SELECTOR_LITERAL);
        uniqueSelector.setValue("simpleRecursiveElementDeclaration");
        unique.setSelector(uniqueSelector);
        XSDXPathDefinition uniqueField = this.xsdFactory.createXSDXPathDefinition();
        uniqueField.setVariety(XSDXPathVariety.FIELD_LITERAL);
        uniqueField.setValue("simpleAttributeDeclarationGroupMember");
        unique.getFields().add((Object)uniqueField);
        simpleRecursiveElementDeclaration.getIdentityConstraintDefinitions().add((Object)unique);
        XSDIdentityConstraintDefinition key = this.xsdFactory.createXSDIdentityConstraintDefinition();
        key.setIdentityConstraintCategory(XSDIdentityConstraintCategory.KEY_LITERAL);
        key.setName("key");
        XSDXPathDefinition keySelector = this.xsdFactory.createXSDXPathDefinition();
        keySelector.setVariety(XSDXPathVariety.SELECTOR_LITERAL);
        keySelector.setValue("simpleRecursiveElementDeclaration");
        key.setSelector(keySelector);
        XSDXPathDefinition keyField = this.xsdFactory.createXSDXPathDefinition();
        keyField.setVariety(XSDXPathVariety.FIELD_LITERAL);
        keyField.setValue("simpleAttributeDeclarationGroupMember");
        key.getFields().add((Object)keyField);
        simpleRecursiveElementDeclaration.getIdentityConstraintDefinitions().add((Object)key);
        XSDIdentityConstraintDefinition keyref = this.xsdFactory.createXSDIdentityConstraintDefinition();
        keyref.setIdentityConstraintCategory(XSDIdentityConstraintCategory.KEYREF_LITERAL);
        keyref.setName("keyref");
        XSDXPathDefinition keyrefSelector = this.xsdFactory.createXSDXPathDefinition();
        keyrefSelector.setVariety(XSDXPathVariety.SELECTOR_LITERAL);
        keyrefSelector.setValue("simpleRecursiveElementDeclaration");
        keyref.setSelector(keyrefSelector);
        XSDXPathDefinition keyrefField = this.xsdFactory.createXSDXPathDefinition();
        keyrefField.setVariety(XSDXPathVariety.FIELD_LITERAL);
        keyrefField.setValue("simpleAttributeDeclaration");
        keyref.setReferencedKey(key);
        keyref.getFields().add((Object)keyrefField);
        simpleRecursiveElementDeclaration.getIdentityConstraintDefinitions().add((Object)keyref);
        this.prototypeSchema.getContents().add((Object)simpleRecursiveElementDeclaration);
    }

    public void initializeSimpleAttributeDeclaration() {
        XSDAttributeDeclaration simpleAttributeDeclaration = this.xsdFactory.createXSDAttributeDeclaration();
        simpleAttributeDeclaration.setName("simpleAttributeDeclaration");
        simpleAttributeDeclaration.setTypeDefinition(this.prototypeSchema.resolveSimpleTypeDefinition(this.someOtherSchemaURI, "someOtherTypeDefinition"));
        simpleAttributeDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
        simpleAttributeDeclaration.setLexicalValue("defaultValue");
        this.prototypeSchema.getContents().add((Object)simpleAttributeDeclaration);
    }

    public void initializeSimpleElementDeclarationWithAnonymousType() {
        XSDElementDeclaration simpleElementDeclarationWithAnonymousType = this.xsdFactory.createXSDElementDeclaration();
        simpleElementDeclarationWithAnonymousType.setName("simpleElementWithAnonymousType");
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleElementDeclarationWithAnonymousType.setAnnotation(annotation);
        XSDSimpleTypeDefinition anonymousSimpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        anonymousSimpleTypeDefinition.setBaseTypeDefinition(this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDPatternFacet xsdPatternFacet = this.xsdFactory.createXSDPatternFacet();
        xsdPatternFacet.setLexicalValue("\\d\\d..");
        anonymousSimpleTypeDefinition.getFacetContents().add((Object)xsdPatternFacet);
        simpleElementDeclarationWithAnonymousType.setAnnotation(annotation);
        simpleElementDeclarationWithAnonymousType.setAnonymousTypeDefinition(anonymousSimpleTypeDefinition);
        simpleElementDeclarationWithAnonymousType.setConstraint(XSDConstraint.FIXED_LITERAL);
        simpleElementDeclarationWithAnonymousType.setLexicalValue("12ab");
        this.prototypeSchema.getContents().add((Object)simpleElementDeclarationWithAnonymousType);
    }

    public void initializeSimpleTypeDefinition() {
        XSDSimpleTypeDefinition simpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleTypeDefinition.setName("SimpleTypeDefinition");
        simpleTypeDefinition.setBaseTypeDefinition(this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("positiveInteger"));
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleTypeDefinition.setAnnotation(annotation);
        XSDMaxInclusiveFacet xsdMaxInclusiveFacet = this.xsdFactory.createXSDMaxInclusiveFacet();
        xsdMaxInclusiveFacet.setLexicalValue("100");
        simpleTypeDefinition.getFacetContents().add((Object)xsdMaxInclusiveFacet);
        this.prototypeSchema.getContents().add((Object)simpleTypeDefinition);
    }

    public void initializeSimpleListTypeDefinition() {
        XSDSimpleTypeDefinition simpleListTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleListTypeDefinition.setName("SimpleListTypeDefinition");
        simpleListTypeDefinition.setItemTypeDefinition(this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("integer"));
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleListTypeDefinition.setAnnotation(annotation);
        this.prototypeSchema.getContents().add((Object)simpleListTypeDefinition);
    }

    public void initializeSimpleUnionTypeDefinition() {
        XSDSimpleTypeDefinition simpleUnionTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleUnionTypeDefinition.setName("SimpleUnionTypeDefinition");
        simpleUnionTypeDefinition.getMemberTypeDefinitions().add((Object)this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("integer"));
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleUnionTypeDefinition.setAnnotation(annotation);
        this.prototypeSchema.getContents().add((Object)simpleUnionTypeDefinition);
    }

    public void initializeFancyListTypeDefinition() {
        XSDSimpleTypeDefinition fancyListTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        fancyListTypeDefinition.setName("FancyListTypeDefinition");
        XSDSimpleTypeDefinition listTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        XSDSimpleTypeDefinition unionTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        XSDSimpleTypeDefinition firstMemberTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        firstMemberTypeDefinition.setBaseTypeDefinition(this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDEnumerationFacet xsdEnumerationFacet = this.xsdFactory.createXSDEnumerationFacet();
        xsdEnumerationFacet.setLexicalValue("unknown");
        firstMemberTypeDefinition.getFacetContents().add((Object)xsdEnumerationFacet);
        unionTypeDefinition.getContents().add((Object)firstMemberTypeDefinition);
        unionTypeDefinition.getMemberTypeDefinitions().add((Object)firstMemberTypeDefinition);
        XSDSimpleTypeDefinition secondMemberTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        secondMemberTypeDefinition.setBaseTypeDefinition(this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("decimal"));
        XSDFractionDigitsFacet xsdFractionDigitsFacet = this.xsdFactory.createXSDFractionDigitsFacet();
        xsdFractionDigitsFacet.setLexicalValue("2");
        secondMemberTypeDefinition.getFacetContents().add((Object)xsdFractionDigitsFacet);
        unionTypeDefinition.getContents().add((Object)secondMemberTypeDefinition);
        unionTypeDefinition.getMemberTypeDefinitions().add((Object)secondMemberTypeDefinition);
        listTypeDefinition.getContents().add((Object)unionTypeDefinition);
        listTypeDefinition.setItemTypeDefinition(unionTypeDefinition);
        fancyListTypeDefinition.getContents().add((Object)listTypeDefinition);
        fancyListTypeDefinition.setBaseTypeDefinition(listTypeDefinition);
        XSDMaxLengthFacet xsdMaxLengthFacet = this.xsdFactory.createXSDMaxLengthFacet();
        xsdMaxLengthFacet.setLexicalValue("4");
        fancyListTypeDefinition.getFacetContents().add((Object)xsdMaxLengthFacet);
        this.prototypeSchema.getContents().add((Object)fancyListTypeDefinition);
    }

    public void initializeSimpleContentComplexTypeDefinition() {
        XSDComplexTypeDefinition simpleContentComplexTypeDefinition = this.xsdFactory.createXSDComplexTypeDefinition();
        simpleContentComplexTypeDefinition.setName("SimpleContentComplexTypeDefinition");
        simpleContentComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        simpleContentComplexTypeDefinition.setAnnotation(annotation);
        XSDSimpleTypeDefinition anonymousSimpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        simpleContentComplexTypeDefinition.setBaseTypeDefinition(this.prototypeSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        simpleContentComplexTypeDefinition.setContent(anonymousSimpleTypeDefinition);
        XSDAttributeDeclaration simpleAttributeDeclarationReference = this.xsdFactory.createXSDAttributeDeclaration();
        simpleAttributeDeclarationReference.setResolvedAttributeDeclaration(this.prototypeSchema.resolveAttributeDeclaration("simpleAttributeDeclaration"));
        XSDAttributeUse simpleAttributeUse = this.xsdFactory.createXSDAttributeUse();
        simpleAttributeUse.setContent(simpleAttributeDeclarationReference);
        simpleAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        simpleContentComplexTypeDefinition.getAttributeContents().add((Object)simpleAttributeUse);
        this.prototypeSchema.getContents().add((Object)simpleContentComplexTypeDefinition);
    }

    public XSDSchema initializePurchaseOrderSchema() {
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        xsdSchema.setTargetNamespace("http://nist.gov/po.xsd");
        Map<String, String> qNamePrefixToNamespaceMap = xsdSchema.getQNamePrefixToNamespaceMap();
        qNamePrefixToNamespaceMap.put("po", xsdSchema.getTargetNamespace());
        qNamePrefixToNamespaceMap.put(xsdSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        XSDAnnotation xsdAnnotation = this.xsdFactory.createXSDAnnotation();
        xsdSchema.getContents().add((Object)xsdAnnotation);
        Element documentation = xsdAnnotation.createUserInformation(null);
        documentation.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "en");
        String text = "Purchase order schema for Example.com.\nCopyright 2000 Example.com. All rights reserved.";
        documentation.appendChild(documentation.getOwnerDocument().createTextNode(text));
        xsdAnnotation.getElement().appendChild(documentation);
        XSDElementDeclaration purchaseOrder = this.xsdFactory.createXSDElementDeclaration();
        purchaseOrder.setName("purchaseOrder");
        purchaseOrder.setTypeDefinition(xsdSchema.resolveComplexTypeDefinition("PurchaseOrderType"));
        xsdSchema.getContents().add((Object)purchaseOrder);
        XSDElementDeclaration comment = this.xsdFactory.createXSDElementDeclaration();
        comment.setName("comment");
        comment.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        xsdSchema.getContents().add((Object)comment);
        XSDComplexTypeDefinition purchaseOrderType = this.xsdFactory.createXSDComplexTypeDefinition();
        purchaseOrderType.setName("PurchaseOrderType");
        XSDModelGroup purchaseOrderTypeSequence = this.xsdFactory.createXSDModelGroup();
        purchaseOrderTypeSequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle purchaseOrderTypeParticle = this.xsdFactory.createXSDParticle();
        purchaseOrderTypeParticle.setContent(purchaseOrderTypeSequence);
        XSDElementDeclaration shipTo = this.xsdFactory.createXSDElementDeclaration();
        shipTo.setName("shipTo");
        shipTo.setTypeDefinition(xsdSchema.resolveComplexTypeDefinition("USAddress"));
        XSDParticle shipToParticle = this.xsdFactory.createXSDParticle();
        shipToParticle.setContent(shipTo);
        purchaseOrderTypeSequence.getContents().add((Object)shipToParticle);
        XSDElementDeclaration billTo = this.xsdFactory.createXSDElementDeclaration();
        billTo.setName("billTo");
        billTo.setTypeDefinition(xsdSchema.resolveComplexTypeDefinition("USAddress"));
        XSDParticle billToParticle = this.xsdFactory.createXSDParticle();
        billToParticle.setContent(billTo);
        purchaseOrderTypeSequence.getContents().add((Object)billToParticle);
        XSDElementDeclaration commentRef = this.xsdFactory.createXSDElementDeclaration();
        commentRef.setResolvedElementDeclaration(xsdSchema.resolveElementDeclaration("comment"));
        XSDParticle commentRefParticle = this.xsdFactory.createXSDParticle();
        commentRefParticle.setMinOccurs(0);
        commentRefParticle.setContent(commentRef);
        purchaseOrderTypeSequence.getContents().add((Object)commentRefParticle);
        XSDElementDeclaration items = this.xsdFactory.createXSDElementDeclaration();
        items.setName("items");
        items.setTypeDefinition(xsdSchema.resolveComplexTypeDefinition("Items"));
        XSDParticle itemsParticle = this.xsdFactory.createXSDParticle();
        itemsParticle.setContent(items);
        purchaseOrderTypeSequence.getContents().add((Object)billToParticle);
        purchaseOrderType.setContent(purchaseOrderTypeParticle);
        XSDAttributeDeclaration orderDate = this.xsdFactory.createXSDAttributeDeclaration();
        orderDate.setName("orderDate");
        orderDate.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("date"));
        XSDAttributeUse orderDateAttributeUse = this.xsdFactory.createXSDAttributeUse();
        orderDateAttributeUse.setContent(orderDate);
        purchaseOrderType.getAttributeContents().add((Object)orderDateAttributeUse);
        xsdSchema.getContents().add((Object)purchaseOrderType);
        XSDComplexTypeDefinition usAddress = this.xsdFactory.createXSDComplexTypeDefinition();
        usAddress.setName("USAddress");
        XSDModelGroup usAddressSequence = this.xsdFactory.createXSDModelGroup();
        usAddressSequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle usAddressParticle = this.xsdFactory.createXSDParticle();
        usAddressParticle.setContent(usAddressSequence);
        XSDElementDeclaration name = this.xsdFactory.createXSDElementDeclaration();
        name.setName("name");
        name.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDParticle nameParticle = this.xsdFactory.createXSDParticle();
        nameParticle.setContent(name);
        usAddressSequence.getContents().add((Object)nameParticle);
        XSDElementDeclaration street = this.xsdFactory.createXSDElementDeclaration();
        street.setName("street");
        street.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDParticle streeParticle = this.xsdFactory.createXSDParticle();
        streeParticle.setContent(street);
        usAddressSequence.getContents().add((Object)streeParticle);
        XSDElementDeclaration city = this.xsdFactory.createXSDElementDeclaration();
        city.setName("city");
        city.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDParticle cityParticle = this.xsdFactory.createXSDParticle();
        cityParticle.setContent(city);
        usAddressSequence.getContents().add((Object)cityParticle);
        XSDElementDeclaration state = this.xsdFactory.createXSDElementDeclaration();
        state.setName("state");
        state.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDParticle stateParticle = this.xsdFactory.createXSDParticle();
        stateParticle.setContent(state);
        usAddressSequence.getContents().add((Object)stateParticle);
        XSDElementDeclaration zip = this.xsdFactory.createXSDElementDeclaration();
        zip.setName("zip");
        zip.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDParticle zipParticle = this.xsdFactory.createXSDParticle();
        zipParticle.setContent(zip);
        usAddressSequence.getContents().add((Object)zipParticle);
        usAddress.setContent(usAddressParticle);
        XSDAttributeDeclaration country = this.xsdFactory.createXSDAttributeDeclaration();
        country.setName("country");
        country.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("NMTOKEN"));
        XSDAttributeUse countryAttributeUse = this.xsdFactory.createXSDAttributeUse();
        countryAttributeUse.setContent(country);
        countryAttributeUse.setConstraint(XSDConstraint.FIXED_LITERAL);
        countryAttributeUse.setLexicalValue("US");
        usAddress.getAttributeContents().add((Object)countryAttributeUse);
        xsdSchema.getContents().add((Object)usAddress);
        XSDComplexTypeDefinition itemsType = this.xsdFactory.createXSDComplexTypeDefinition();
        itemsType.setName("Items");
        XSDModelGroup itemsTypeSequence = this.xsdFactory.createXSDModelGroup();
        itemsTypeSequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle itemsTypeParticle = this.xsdFactory.createXSDParticle();
        itemsTypeParticle.setContent(itemsTypeSequence);
        XSDElementDeclaration item = this.xsdFactory.createXSDElementDeclaration();
        item.setName("item");
        XSDComplexTypeDefinition anonymousComplexTypeDefinition = this.xsdFactory.createXSDComplexTypeDefinition();
        XSDModelGroup anonymousComplexTypeDefinitionSequence = this.xsdFactory.createXSDModelGroup();
        anonymousComplexTypeDefinitionSequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle anonymousTypeDefinitionParticle = this.xsdFactory.createXSDParticle();
        anonymousTypeDefinitionParticle.setContent(anonymousComplexTypeDefinitionSequence);
        XSDElementDeclaration productName = this.xsdFactory.createXSDElementDeclaration();
        productName.setName("productName");
        productName.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDParticle productNameParticle = this.xsdFactory.createXSDParticle();
        productNameParticle.setContent(productName);
        anonymousComplexTypeDefinitionSequence.getContents().add((Object)productNameParticle);
        XSDParticle itemParticle = this.xsdFactory.createXSDParticle();
        itemParticle.setContent(item);
        itemsTypeSequence.getContents().add((Object)itemParticle);
        XSDAttributeDeclaration partNum = this.xsdFactory.createXSDAttributeDeclaration();
        partNum.setName("partNum");
        partNum.setTypeDefinition(xsdSchema.resolveSimpleTypeDefinition("SKU"));
        XSDAttributeUse partNumAttributeUse = this.xsdFactory.createXSDAttributeUse();
        partNumAttributeUse.setContent(partNum);
        partNumAttributeUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
        itemsType.getAttributeContents().add((Object)partNumAttributeUse);
        anonymousComplexTypeDefinition.setContent(anonymousTypeDefinitionParticle);
        XSDElementDeclaration quantity = this.xsdFactory.createXSDElementDeclaration();
        quantity.setName("quantity");
        XSDSimpleTypeDefinition anonymousSimpleTypeDefinition = this.xsdFactory.createXSDSimpleTypeDefinition();
        anonymousSimpleTypeDefinition.setBaseTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("positiveInteger"));
        XSDMaxExclusiveFacet quantityMaxExclusiveFacet = this.xsdFactory.createXSDMaxExclusiveFacet();
        quantityMaxExclusiveFacet.setLexicalValue("100");
        anonymousSimpleTypeDefinition.getFacetContents().add((Object)quantityMaxExclusiveFacet);
        quantity.setAnonymousTypeDefinition(anonymousSimpleTypeDefinition);
        XSDParticle quantityParticle = this.xsdFactory.createXSDParticle();
        quantityParticle.setContent(quantity);
        anonymousComplexTypeDefinitionSequence.getContents().add((Object)quantityParticle);
        XSDElementDeclaration usPrice = this.xsdFactory.createXSDElementDeclaration();
        usPrice.setName("USPrice");
        usPrice.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("decimal"));
        XSDParticle usPriceParticle = this.xsdFactory.createXSDParticle();
        usPriceParticle.setContent(usPrice);
        anonymousComplexTypeDefinitionSequence.getContents().add((Object)usPriceParticle);
        XSDElementDeclaration anotherCommentRef = this.xsdFactory.createXSDElementDeclaration();
        anotherCommentRef.setResolvedElementDeclaration(xsdSchema.resolveElementDeclaration("comment"));
        XSDParticle anotherCommentRefParticle = this.xsdFactory.createXSDParticle();
        anotherCommentRefParticle.setMinOccurs(0);
        anotherCommentRefParticle.setContent(anotherCommentRef);
        anonymousComplexTypeDefinitionSequence.getContents().add((Object)anotherCommentRefParticle);
        XSDElementDeclaration shipDate = this.xsdFactory.createXSDElementDeclaration();
        shipDate.setName("shipDate");
        shipDate.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("decimal"));
        XSDParticle shipDateParticle = this.xsdFactory.createXSDParticle();
        shipDateParticle.setContent(shipDate);
        shipDateParticle.setMinOccurs(0);
        anonymousComplexTypeDefinitionSequence.getContents().add((Object)shipDateParticle);
        itemsType.setContent(itemsTypeParticle);
        item.setAnonymousTypeDefinition(anonymousComplexTypeDefinition);
        xsdSchema.getContents().add((Object)itemsType);
        XSDSimpleTypeDefinition sku = this.xsdFactory.createXSDSimpleTypeDefinition();
        sku.setName("Sku");
        sku.setBaseTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        XSDPatternFacet skuPatternFacet = this.xsdFactory.createXSDPatternFacet();
        skuPatternFacet.setLexicalValue("/d{3}-[A-Z]{2}");
        sku.getFacetContents().add((Object)skuPatternFacet);
        xsdSchema.getContents().add((Object)sku);
        return xsdSchema;
    }

    public void savePurchaseOrderSchema(String schemaURI) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            XSDResourceImpl resource = new XSDResourceImpl(URI.createURI((String)schemaURI));
            resource.getContents().add((Object)this.purchaseOrderSchema);
            resourceSet.getResources().add((Object)resource);
            resource.save(Collections.EMPTY_MAP);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public void printSchema(String xsdSchemaURI) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
            resourceSet.getResource(URI.createURI((String)xsdSchemaURI), true);
            for (Resource resource : resourceSet.getResources()) {
                if (!(resource instanceof XSDResourceImpl)) continue;
                XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
                XSDSchema xsdSchema = xsdResource.getSchema();
                System.out.println("\n<!-- *** " + xsdResource.getURI() + " *** -->\n");
                this.printComponent(System.out, xsdSchema);
                if (xsdSchema.getAllDiagnostics().isEmpty()) {
                    xsdSchema.validate();
                }
                for (XSDDiagnostic xsdDiagnostic : xsdSchema.getAllDiagnostics()) {
                    String localizedSeverity = XSDPlugin.INSTANCE.getString("_UI_XSDDiagnosticSeverity_" + (Object)((Object)xsdDiagnostic.getSeverity()));
                    System.out.println(XSDPlugin.INSTANCE.getString("_UI_DiagnosticFileLineColumn_message", new Object[]{localizedSeverity, xsdDiagnostic.getLocationURI(), new Integer(xsdDiagnostic.getLine()), new Integer(xsdDiagnostic.getColumn())}));
                    System.out.println(xsdDiagnostic.getMessage());
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public void printComponent(OutputStream outputStream, XSDConcreteComponent xsdConcreteComponent) {
        Element element = xsdConcreteComponent.getElement();
        if (element == null) {
            xsdConcreteComponent.updateElement();
            element = xsdConcreteComponent.getElement();
        }
        if (element != null) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.transform(new DOMSource(element.getOwnerDocument()), new StreamResult(outputStream));
            }
            catch (TransformerException exception) {
                System.out.println(exception.getLocalizedMessage());
                exception.printStackTrace();
            }
        }
    }

    public XSDSchema createSchema(Element element) {
        if (element.getLocalName().equals("schema") && XSDConstants.isSchemaForSchemaNamespace(element.getNamespaceURI())) {
            XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            xsdSchema.setElement(element);
            return xsdSchema;
        }
        return null;
    }

    public void traceLoading(String xsdSchemaURI) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl(){

                public Resource getResource(URI uri, boolean loadOnDemand) {
                    Resource result = super.getResource(uri, true);
                    System.out.println("<!-- loaded: " + uri + " --> " + result);
                    return result;
                }
            };
            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)"http://www.example.com/logical.xsd"), URI.createURI((String)"file://c:/physical.xsd"));
            resourceSet.getResource(URI.createURI((String)xsdSchemaURI), true);
            for (Resource resource : resourceSet.getResources()) {
                if (!(resource instanceof XSDResourceImpl)) continue;
                XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
                XSDSchema xsdSchema = xsdResource.getSchema();
                for (XSDSchemaContent xsdSchemaContent : xsdSchema.getContents()) {
                    XSDSchemaDirective xsdSchemaDirective;
                    if (!(xsdSchemaContent instanceof XSDSchemaDirective) || (xsdSchemaDirective = (XSDSchemaDirective)xsdSchemaContent).getResolvedSchema() != null) continue;
                    System.out.println("Unresolved schema in " + xsdResource.getURI());
                    this.printComponent(System.out, xsdSchemaDirective);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public XSDConcreteComponent cloneComponent(XSDConcreteComponent xsdConcreteComponent, boolean preserveDOM) {
        Element element;
        if (preserveDOM && (element = xsdConcreteComponent.getElement()) != null) {
            Element clonedElement = (Element)element.cloneNode(true);
            XSDConcreteComponent result = (XSDConcreteComponent)XSDFactory.eINSTANCE.create(xsdConcreteComponent.eClass());
            result.setElement(clonedElement);
            return result;
        }
        XSDConcreteComponent result = xsdConcreteComponent.cloneConcreteComponent(true, false);
        return result;
    }

    public void crossReferenceTest(PrintStream out) {
        XSDSchema xsdSchemaForSchema = XSDUtil.getSchemaForSchema("http://www.w3.org/2001/XMLSchema");
        ResourceSet resourceSet = xsdSchemaForSchema.eResource().getResourceSet();
        out.println("Show uses of the string datatype within the meta schemas themselves.");
        Collection<EStructuralFeature.Setting> usages = XSDUtil.UsageCrossReferencer.find((EObject)xsdSchemaForSchema.resolveSimpleTypeDefinition("string"), resourceSet);
        EcoreUtil.CrossReferencer.print((PrintStream)out, usages);
        out.println("Show uses of the ur-type URI");
        Map<EObject, Collection<EStructuralFeature.Setting>> xsdURICrossReferences = XSDUtil.URICrossReferencer.find("http://www.w3.org/2001/XMLSchema#anyType", resourceSet);
        EcoreUtil.CrossReferencer.print((PrintStream)out, xsdURICrossReferences);
        out.println("Show all named components and their uses in the schema of the anySimpleType.");
        Map<EObject, Collection<EStructuralFeature.Setting>> xsdNamedComponentUsage = XSDUtil.XSDNamedComponentCrossReferencer.find(xsdSchemaForSchema.resolveSimpleTypeDefinition("anySimpleType").getSchema());
        EcoreUtil.CrossReferencer.print((PrintStream)out, xsdNamedComponentUsage);
        out.println("Test that the URI of evey object in the schema for schemas can be resolved.");
        TreeIterator contents = xsdSchemaForSchema.eAllContents();
        while (contents.hasNext()) {
            XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)contents.next();
            URI uri = EcoreUtil.getURI((EObject)xsdConcreteComponent);
            if (resourceSet.getEObject(uri, false) == xsdConcreteComponent) continue;
            out.println("BAD URI: " + uri);
        }
    }
}

