/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public abstract class CorrectOddnessCheckResolution
extends BugResolution {
    protected boolean resolveBindings() {
        return false;
    }

    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        assert (rewrite != null);
        assert (workingUnit != null);
        assert (bug != null);
        InfixExpression oddnessCheck = this.findOddnessCheck(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()));
        if (oddnessCheck == null) {
            throw new BugResolutionException("No matching oddness check found at the specified source line.");
        }
        Expression numberExpression = this.findNumberExpression(oddnessCheck);
        if (numberExpression == null) {
            throw new BugResolutionException();
        }
        InfixExpression correctOddnessCheck = this.createCorrectOddnessCheck(rewrite, numberExpression);
        rewrite.replace((ASTNode)oddnessCheck, (ASTNode)correctOddnessCheck, null);
    }

    @CheckForNull
    protected InfixExpression findOddnessCheck(ASTNode node) {
        OddnessCheckFinder finder = new OddnessCheckFinder();
        node.accept((ASTVisitor)finder);
        return finder.getOddnessCheck();
    }

    @CheckForNull
    protected Expression findNumberExpression(InfixExpression oddnessCheck) {
        NumberExpressionFinder finder = new NumberExpressionFinder();
        oddnessCheck.accept((ASTVisitor)finder);
        return finder.getNumberExpression();
    }

    protected abstract InfixExpression createCorrectOddnessCheck(ASTRewrite var1, Expression var2);

    protected static boolean isOddnessCheck(InfixExpression oddnessCheck) {
        if (InfixExpression.Operator.EQUALS.equals(oddnessCheck.getOperator())) {
            if (CorrectOddnessCheckResolution.isRemainderExp(oddnessCheck.getLeftOperand())) {
                return CorrectOddnessCheckResolution.isNumber(oddnessCheck.getRightOperand(), 1);
            }
            if (CorrectOddnessCheckResolution.isRemainderExp(oddnessCheck.getRightOperand())) {
                return CorrectOddnessCheckResolution.isNumber(oddnessCheck.getLeftOperand(), 1);
            }
        }
        return false;
    }

    protected static boolean isRemainderExp(Expression remainderExp) {
        while (remainderExp instanceof ParenthesizedExpression) {
            remainderExp = ((ParenthesizedExpression)remainderExp).getExpression();
        }
        if (remainderExp instanceof InfixExpression) {
            InfixExpression exp = (InfixExpression)remainderExp;
            return InfixExpression.Operator.REMAINDER.equals(exp.getOperator()) && CorrectOddnessCheckResolution.isNumber(exp.getRightOperand(), 2);
        }
        return false;
    }

    protected static boolean isNumber(Expression exp, int number) {
        return exp instanceof NumberLiteral && Integer.parseInt(((NumberLiteral)exp).getToken()) == number;
    }

    protected static class NumberExpressionFinder
    extends ASTVisitor {
        private Expression numberExpression = null;

        protected NumberExpressionFinder() {
        }

        public boolean visit(InfixExpression node) {
            if (this.numberExpression == null) {
                if (!CorrectOddnessCheckResolution.isRemainderExp((Expression)node)) {
                    return true;
                }
                this.numberExpression = node.getLeftOperand();
            }
            return false;
        }

        public Expression getNumberExpression() {
            return this.numberExpression;
        }
    }

    protected static class OddnessCheckFinder
    extends ASTVisitor {
        private InfixExpression oddnessCheck = null;

        protected OddnessCheckFinder() {
        }

        public boolean visit(InfixExpression node) {
            if (this.oddnessCheck == null) {
                if (!CorrectOddnessCheckResolution.isOddnessCheck(node)) {
                    return true;
                }
                this.oddnessCheck = node;
            }
            return false;
        }

        public InfixExpression getOddnessCheck() {
            return this.oddnessCheck;
        }
    }
}

