/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.util;

import de.tobject.findbugs.FindbugsPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class Util {
    public static boolean isJavaFile(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String ex = resource.getFileExtension();
        return "java".equalsIgnoreCase(ex);
    }

    public static boolean isClassFile(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String ex = resource.getFileExtension();
        return "class".equalsIgnoreCase(ex);
    }

    public static boolean isJavaArtifact(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String ex = resource.getFileExtension();
        return "java".equalsIgnoreCase(ex) || "class".equalsIgnoreCase(ex);
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project != null && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "couldn't determine project nature");
            return false;
        }
    }
}

