/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MarkerReporter
implements IWorkspaceRunnable {
    private BugInstance bug;
    private IResource resource;
    private int startLine;
    private BugCollection collection;
    private static final boolean EXPERIMENTAL_BUGS = false;

    public MarkerReporter(BugInstance bug, IResource resource, int startLine, BugCollection theCollection, IProject project) {
        this.startLine = startLine;
        this.bug = bug;
        this.resource = resource;
        this.collection = theCollection;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        String markerType = this.getMarkerType();
        if (markerType == null) {
            return;
        }
        IMarker marker = this.resource.createMarker(markerType);
        this.setAttributes(marker);
    }

    private String getMarkerType() {
        String markerType;
        switch (this.bug.getPriority()) {
            case 1: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerHigh";
                break;
            }
            case 2: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerNormal";
                break;
            }
            case 3: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerLow";
                break;
            }
            case 4: {
                return null;
            }
            case 5: {
                FindbugsPlugin.getDefault().logError("Bug with ignore priority ");
                return null;
            }
            default: {
                FindbugsPlugin.getDefault().logError("Bug with unknown priority " + this.bug.getPriority());
                return null;
            }
        }
        return markerType;
    }

    private void setAttributes(IMarker marker) throws CoreException {
        marker.setAttribute("lineNumber", this.startLine);
        marker.setAttribute("BUGTYPE", (Object)this.bug.getType());
        long seqNum = this.bug.getFirstVersion();
        if (seqNum == 0L) {
            marker.setAttribute("FIRST_VERSION", (Object)"-1");
        } else {
            AppVersion theVersion = this.collection.getAppVersionFromSequenceNumber(seqNum);
            if (theVersion == null) {
                marker.setAttribute("FIRST_VERSION", (Object)("Cannot find AppVersion: seqnum=" + seqNum + "; collection seqnum=" + this.collection.getSequenceNumber()));
            } else {
                marker.setAttribute("FIRST_VERSION", (Object)Long.toString(theVersion.getTimestamp()));
            }
        }
        try {
            marker.setAttribute("message", (Object)this.bug.getMessageWithPriorityTypeAbbreviation());
        }
        catch (RuntimeException e) {
            FindbugsPlugin.getDefault().logException(e, "Error generating msg for " + this.bug.getType());
            marker.setAttribute("message", (Object)("??? " + this.bug.getType()));
        }
        marker.setAttribute("severity", 1);
        marker.setAttribute("PRIORITY_TYPE", (Object)this.bug.getPriorityTypeString());
        switch (this.bug.getPriority()) {
            case 1: {
                marker.setAttribute("priority", 2);
                break;
            }
            case 2: {
                marker.setAttribute("priority", 1);
                break;
            }
            default: {
                marker.setAttribute("priority", 0);
            }
        }
        marker.setAttribute("PATTERN_DESCR_SHORT", (Object)this.bug.getBugPattern().getShortDescription());
        String uniqueId = this.bug.getInstanceHash();
        if (uniqueId != null) {
            marker.setAttribute("FINDBUGS_UNIQUE_ID", (Object)uniqueId);
        }
    }
}

