/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.actions.FindBugsAction;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.builder.ResourceUtils;
import edu.umd.cs.findbugs.plugin.eclipse.util.MutexSchedulingRule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadXmlAction
extends FindBugsAction
implements IEditorActionDelegate {
    @Override
    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            List<IProject> projects = this.getProjects(structuredSelection);
            for (IProject project : projects) {
                FileDialog theDialog = new FileDialog(new Shell(), 69632);
                theDialog.setText("Select bug result xml for project: " + project.getName());
                String theFileName = theDialog.open();
                if (theFileName == null) continue;
                this.work(project, theFileName);
            }
        }
    }

    private List<IProject> getProjects(IStructuredSelection structuredSelection) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (Object element : structuredSelection) {
            IProject project;
            IResource resource = ResourceUtils.getResource(element);
            if (resource == null || projects.contains(project = resource.getProject())) continue;
            projects.add(project);
        }
        return projects;
    }

    protected final void work(final IProject project, final String fileName) {
        Job runFindBugs = new Job("Loading XML data from..." + fileName + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FindBugsWorker worker = new FindBugsWorker(project, monitor);
                    worker.loadXml(fileName);
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Analysis exception");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        runFindBugs.setUser(true);
        runFindBugs.setRule((ISchedulingRule)new MutexSchedulingRule(project));
        runFindBugs.schedule();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.usedInEditor = true;
        if (targetEditor instanceof AbstractDecoratedTextEditor) {
            AbstractDecoratedTextEditor editor = (AbstractDecoratedTextEditor)targetEditor;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput editorInput = (IFileEditorInput)input;
                this.selection = new StructuredSelection((Object)editorInput.getFile());
            }
        } else {
            this.selection = null;
        }
    }
}

