/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.Util;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ClearMarkersAction
implements IObjectActionDelegate {
    private ISelection currentSelection;

    public final void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    public final void run(IAction action) {
        if (!this.currentSelection.isEmpty() && this.currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.currentSelection;
            this.work(structuredSelection);
        }
    }

    private void work(final IStructuredSelection selection) {
        try {
            IRunnableWithProgress r = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        for (IAdaptable adaptable : selection) {
                            IResource res;
                            Object resource = adaptable.getAdapter(IResource.class);
                            IResource iResource = res = resource instanceof IResource ? (IResource)resource : null;
                            if (res != null) {
                                pm.subTask("Clearing FindBugs markers from " + res.getName());
                                MarkerUtil.removeMarkers(res);
                                continue;
                            }
                            ChangeSet set = (ChangeSet)adaptable.getAdapter(ChangeSet.class);
                            for (IResource change : ResourceUtils.getResources(set)) {
                                if (!Util.isJavaArtifact(change)) continue;
                                pm.subTask("Clearing FindBugs markers from " + change.getName());
                                MarkerUtil.removeMarkers(change);
                            }
                        }
                    }
                    catch (CoreException ex) {
                        FindbugsPlugin.getDefault().logException(ex, "CoreException on clear markers");
                        throw new InvocationTargetException(ex);
                    }
                    catch (RuntimeException ex) {
                        FindbugsPlugin.getDefault().logException(ex, "RuntimeException on clear markers");
                        throw ex;
                    }
                }
            };
            ProgressMonitorDialog progress = new ProgressMonitorDialog(FindbugsPlugin.getShell());
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            FindbugsPlugin.getDefault().logException(e, "InvocationTargetException on clear markers");
        }
        catch (InterruptedException e) {
            FindbugsPlugin.getDefault().logException(e, "InterruptedException on clear markers");
        }
    }
}

