/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Visitor;

public class VolatileUsage
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    Set<XField> initializationWrites = new HashSet<XField>();
    Set<XField> otherWrites = new HashSet<XField>();

    public VolatileUsage(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 179: {
                XField f = this.getXFieldOperand();
                if (!this.interesting(f)) {
                    return;
                }
                if (this.getMethodName().equals("<clinit>")) {
                    this.initializationWrites.add(f);
                    break;
                }
                this.otherWrites.add(f);
                break;
            }
            case 181: {
                XField f = this.getXFieldOperand();
                if (!this.interesting(f)) {
                    return;
                }
                if (this.getMethodName().equals("<init>")) {
                    this.initializationWrites.add(f);
                    break;
                }
                this.otherWrites.add(f);
                break;
            }
        }
    }

    public void report() {
        for (XField f : AnalysisContext.currentXFactory().allFields()) {
            if (!this.interesting(f)) continue;
            int priority = 3;
            if (this.initializationWrites.contains(f) && !this.otherWrites.contains(f)) {
                priority = 2;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "VO_VOLATILE_REFERENCE_TO_ARRAY", priority).addClass(f.getClassDescriptor()).addField(f));
        }
    }

    private boolean interesting(XField f) {
        return f != null && f.isVolatile() && f.getSignature().charAt(0) == '[';
    }
}

