/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import java.util.Iterator;

public class TestDataflowAnalysis
implements Detector2,
NonReportingDetector {
    private String dataflowClassName = SystemProperties.getProperty((String)"dataflow.classname");
    private String methodName = SystemProperties.getProperty((String)"dataflow.method");
    private Class<? extends Dataflow> dataflowClass;
    private boolean initialized;

    public TestDataflowAnalysis(BugReporter bugReporter) {
    }

    public void finishPass() {
    }

    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (this.dataflowClassName == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (this.dataflowClass == null) {
            return;
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        ClassInfo classInfo = (ClassInfo)analysisCache.getClassAnalysis(ClassInfo.class, classDescriptor);
        for (XMethod xMethod : classInfo.getXMethods()) {
            if (this.methodName != null && !this.methodName.equals(xMethod.getName())) continue;
            MethodDescriptor methodDescriptor = xMethod.getMethodDescriptor();
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Method: " + SignatureConverter.convertMethodSignature((MethodDescriptor)methodDescriptor));
            System.out.println("-----------------------------------------------------------------");
            Dataflow dataflow = (Dataflow)analysisCache.getMethodAnalysis(this.dataflowClass, methodDescriptor);
            System.out.println("Dataflow finished after " + dataflow.getNumIterations());
            if (!SystemProperties.getBoolean((String)"dataflow.printcfg")) continue;
            DataflowCFGPrinter cfgPrinter = new DataflowCFGPrinter(dataflow);
            cfgPrinter.print(System.out);
        }
    }

    private void initialize() throws CheckedAnalysisException {
        this.initialized = true;
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        Class<?> cls = null;
        try {
            cls = this.getClass().getClassLoader().loadClass(this.dataflowClassName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cls == null) {
            DetectorFactoryCollection detectorFactoryCollection = (DetectorFactoryCollection)analysisCache.getDatabase(DetectorFactoryCollection.class);
            Iterator i = detectorFactoryCollection.pluginIterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                PluginLoader pluginLoader = plugin.getPluginLoader();
                try {
                    cls = pluginLoader.getClassLoader().loadClass(this.dataflowClassName);
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        if (cls == null) {
            analysisCache.getErrorLogger().logError("TestDataflowAnalysis: could not load class " + this.dataflowClassName);
            return;
        }
        if (!Dataflow.class.isAssignableFrom(cls)) {
            analysisCache.getErrorLogger().logError("TestDataflowAnalysis: " + this.dataflowClassName + " is not a Dataflow class");
            return;
        }
        this.dataflowClass = cls;
    }
}

