/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bcel.classfile.Code;

public class OverridingEqualsNotSymmetrical
extends BytecodeScanningDetector {
    private static final String EQUALS_NAME = "equals";
    private static final String EQUALS_SIGNATURE = "(Ljava/lang/Object;)Z";
    Map<ClassAnnotation, KindOfEquals> kindMap = new HashMap<ClassAnnotation, KindOfEquals>();
    Map<ClassAnnotation, ClassAnnotation> parentMap = new TreeMap<ClassAnnotation, ClassAnnotation>();
    Map<ClassAnnotation, MethodAnnotation> equalsMethod = new TreeMap<ClassAnnotation, MethodAnnotation>();
    BugReporter bugReporter;
    boolean sawInstanceOf;
    boolean sawCheckedCast;
    boolean sawGetClass;
    boolean sawReturnSuper;
    boolean sawSuperEquals;
    boolean sawReturnNonSuper;
    boolean prevWasSuperEquals;
    boolean sawInitialIdentityCheck;
    int equalsCalls;

    public OverridingEqualsNotSymmetrical(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals(EQUALS_NAME) && !this.getMethod().isStatic() && this.getMethod().isPublic() && this.getMethodSig().equals(EQUALS_SIGNATURE)) {
            this.prevWasSuperEquals = false;
            this.sawReturnNonSuper = false;
            this.sawReturnSuper = false;
            this.sawGetClass = false;
            this.sawInstanceOf = false;
            this.sawSuperEquals = false;
            this.sawCheckedCast = false;
            this.sawInitialIdentityCheck = obj.getCode().length == 11 || obj.getCode().length == 9;
            this.equalsCalls = 0;
            super.visit(obj);
            KindOfEquals kind = KindOfEquals.UNKNOWN;
            if (this.sawReturnSuper && !this.sawReturnNonSuper) {
                kind = KindOfEquals.RETURNS_SUPER;
            } else if (this.sawSuperEquals) {
                kind = KindOfEquals.INVOKES_SUPER;
            } else if (this.sawInstanceOf) {
                kind = this.getThisClass().isAbstract() ? KindOfEquals.ABSTRACT_INSTANCE_OF : KindOfEquals.INSTANCE_OF_EQUALS;
            } else if (this.sawGetClass) {
                kind = KindOfEquals.GETCLASS_EQUALS;
            } else if (this.equalsCalls == 1) {
                kind = KindOfEquals.DELEGATE_EQUALS;
            } else if (this.sawInitialIdentityCheck) {
                kind = KindOfEquals.TRIVIAL_EQUALS;
            } else if (this.sawCheckedCast) {
                kind = KindOfEquals.CHECKED_CAST_EQUALS;
            }
            ClassAnnotation classAnnotation = new ClassAnnotation(this.getDottedClassName());
            this.kindMap.put(classAnnotation, kind);
            String superClassName = this.getSuperclassName().replace('/', '.');
            if (!superClassName.equals("java.lang.Object")) {
                this.parentMap.put(classAnnotation, new ClassAnnotation(superClassName));
            }
            this.equalsMethod.put(classAnnotation, MethodAnnotation.fromVisitedMethod((PreorderVisitor)this));
        }
    }

    public void sawOpcode(int seen) {
        if (this.getPC() == 2 && seen != 165 && seen != 166) {
            this.sawInitialIdentityCheck = false;
        }
        if (seen == 182 && this.getNameConstantOperand().equals(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE)) {
            ++this.equalsCalls;
        }
        if (seen == 183 && this.getNameConstantOperand().equals(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE)) {
            this.prevWasSuperEquals = true;
            this.sawSuperEquals = true;
        } else {
            if (seen == 172) {
                if (this.prevWasSuperEquals) {
                    this.sawReturnSuper = true;
                } else {
                    this.sawReturnNonSuper = true;
                }
            }
            this.prevWasSuperEquals = false;
        }
        if (seen == 193 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.sawInstanceOf = true;
        }
        if (seen == 192 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.sawCheckedCast = true;
        }
        if (seen == 182 && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
            this.sawGetClass = true;
        }
    }

    public void report() {
        for (Map.Entry<ClassAnnotation, ClassAnnotation> e : this.parentMap.entrySet()) {
            ClassAnnotation childClass = e.getKey();
            KindOfEquals childKind = this.kindMap.get(childClass);
            ClassAnnotation parentClass = e.getValue();
            KindOfEquals parentKind = this.kindMap.get(parentClass);
            if (parentKind == null || childKind != KindOfEquals.INSTANCE_OF_EQUALS || parentKind != KindOfEquals.INSTANCE_OF_EQUALS) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_OVERRIDING_EQUALS_NOT_SYMMETRIC", 2).add((BugAnnotation)childClass).add((BugAnnotation)this.equalsMethod.get(childClass)).add((BugAnnotation)this.equalsMethod.get(parentClass)));
        }
    }

    static class KindOfEquals {
        static int next = 0;
        final int ordinal = next++;
        final String name;
        static LinkedList<KindOfEquals> valueCollection = new LinkedList();
        static KindOfEquals OBJECT_EQUALS = new KindOfEquals("OBJECT_EQUALS");
        static KindOfEquals ABSTRACT_INSTANCE_OF = new KindOfEquals("ABSTRACT_INSTANCE_OF");
        static KindOfEquals INSTANCE_OF_EQUALS = new KindOfEquals("INSTANCE_OF_EQUALS");
        static KindOfEquals CHECKED_CAST_EQUALS = new KindOfEquals("CHECKED_CAST_EQUALS");
        static KindOfEquals RETURNS_SUPER = new KindOfEquals("RETURNS_SUPER");
        static KindOfEquals GETCLASS_EQUALS = new KindOfEquals("GETCLASS_EQUALS");
        static KindOfEquals DELEGATE_EQUALS = new KindOfEquals("DELEGATE_EQUALS");
        static KindOfEquals TRIVIAL_EQUALS = new KindOfEquals("TRIVIAL_EQUALS");
        static KindOfEquals INVOKES_SUPER = new KindOfEquals("INVOKES_SUPER");
        static KindOfEquals UNKNOWN = new KindOfEquals("UNKNOWN");

        public static KindOfEquals[] values() {
            return valueCollection.toArray(new KindOfEquals[valueCollection.size()]);
        }

        KindOfEquals(String name) {
            this.name = name;
            valueCollection.add(this);
        }

        public int ordinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }
    }
}

