/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.Analysis;
import edu.umd.cs.findbugs.ba.jsr305.DirectlyRelevantTypeQualifiersDatabase;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class NoteDirectlyRelevantTypeQualifiers
extends DirectlyRelevantTypeQualifiersDatabase
implements Detector,
NonReportingDetector {
    HashSet<TypeQualifierValue> applicableApplications;

    public NoteDirectlyRelevantTypeQualifiers(BugReporter bugReporter) {
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!BCELUtil.preTiger((JavaClass)javaClass)) {
            javaClass.accept((Visitor)this);
        }
    }

    public void visit(Code m) {
        this.applicableApplications = new HashSet();
        XMethod xMethod = this.getXMethod();
        this.updateApplicableAnnotations(xMethod);
        super.visit(m);
        if (this.applicableApplications.size() > 0) {
            this.qualifiers.put(this.getMethodDescriptor(), new ArrayList<TypeQualifierValue>(this.applicableApplications));
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                XMethod m = XFactory.createReferencedXMethod((DismantleBytecode)this);
                this.updateApplicableAnnotations(m);
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                XField f = XFactory.createReferencedXField((DismantleBytecode)this);
                Collection annotations = TypeQualifierApplications.getApplicableApplications((AnnotatedObject)f);
                Analysis.addKnownTypeQualifiers(this.applicableApplications, (Collection)annotations);
                break;
            }
        }
    }

    private void updateApplicableAnnotations(XMethod m) {
        Collection annotations = TypeQualifierApplications.getApplicableApplications((AnnotatedObject)m);
        Analysis.addKnownTypeQualifiers(this.applicableApplications, (Collection)annotations);
        Analysis.addKnownTypeQualifiersForParameters(this.applicableApplications, (XMethod)m);
    }

    public void report() {
    }
}

