/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteAnnotationRetention
extends AnnotationVisitor
implements Detector,
NonReportingDetector {
    private boolean classfileRetention;

    public NoteAnnotationRetention(BugReporter bugReporter) {
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (!annotationClass.equals("java.lang.annotation.Retention")) {
            return;
        }
        Object value = map.get("value");
        if ("java.lang.annotation.RetentionPolicy.RUNTIME".equals(value) || "java.lang.annotation.RetentionPolicy.CLASSFILE".equals(value)) {
            this.classfileRetention = true;
        }
    }

    public void visit(JavaClass obj) {
        this.classfileRetention = false;
    }

    public void visitAfter(JavaClass obj) {
        for (String i : obj.getInterfaceNames()) {
            if (!i.equals("java.lang.annotation.Annotation")) continue;
            AnalysisContext.currentAnalysisContext().getAnnotationRetentionDatabase().setClassfileRetention(this.getDottedClassName(), this.classfileRetention);
        }
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!BCELUtil.preTiger((JavaClass)javaClass)) {
            javaClass.accept((Visitor)this);
        }
    }

    public void report() {
    }
}

