/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class LoadOfKnownNullValue
implements Detector {
    private BugReporter bugReporter;

    public LoadOfKnownNullValue(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException mue) {
                if (!SystemProperties.getBoolean((String)"unprofitable.debug")) continue;
                this.bugReporter.logError("skipping unprofitable method in " + this.getClass().getName());
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        ALOAD load;
        int index;
        IsNullValue v;
        IsNullValueFrame frame;
        Instruction ins;
        InstructionHandle handle;
        Location location;
        Iterator i;
        BitSet lineMentionedMultipleTimes = ClassContext.linesMentionedMultipleTimes((Method)method);
        BitSet linesWithLoadsOfNotDefinitelyNullValues = null;
        CFG cfg = classContext.getCFG(method);
        IsNullValueDataflow nullValueDataflow = classContext.getIsNullValueDataflow(method);
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        if (lineMentionedMultipleTimes.cardinality() > 0) {
            linesWithLoadsOfNotDefinitelyNullValues = new BitSet();
            LineNumberTable lineNumbers = method.getLineNumberTable();
            i = cfg.locationIterator();
            while (i.hasNext()) {
                int sourceLine;
                location = (Location)i.next();
                handle = location.getHandle();
                ins = handle.getInstruction();
                if (!(ins instanceof ALOAD) || !(frame = (IsNullValueFrame)nullValueDataflow.getFactAtLocation(location)).isValid() || (v = (IsNullValue)frame.getValue(index = (load = (ALOAD)ins).getIndex())).isDefinitelyNull() || (sourceLine = lineNumbers.getSourceLine(handle.getPosition())) <= 0) continue;
                linesWithLoadsOfNotDefinitelyNullValues.set(sourceLine);
            }
        }
        IdentityHashMap sometimesGood = new IdentityHashMap();
        i = cfg.locationIterator();
        while (i.hasNext()) {
            location = (Location)i.next();
            handle = location.getHandle();
            ins = handle.getInstruction();
            if (!(ins instanceof ALOAD) || !(frame = (IsNullValueFrame)nullValueDataflow.getFactAtLocation(location)).isValid() || (v = (IsNullValue)frame.getValue(index = (load = (ALOAD)ins).getIndex())).isDefinitelyNull()) continue;
            sometimesGood.put(handle, null);
        }
        i = cfg.locationIterator();
        while (i.hasNext()) {
            int startLine;
            location = (Location)i.next();
            handle = location.getHandle();
            ins = handle.getInstruction();
            if (!(ins instanceof ALOAD) || sometimesGood.containsKey(handle) || !(frame = (IsNullValueFrame)nullValueDataflow.getFactAtLocation(location)).isValid() || !(v = (IsNullValue)frame.getValue(index = (load = (ALOAD)ins).getIndex())).isDefinitelyNull()) continue;
            Instruction next = handle.getNext().getInstruction();
            InstructionHandle prevHandle = handle.getPrev();
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            SourceLineAnnotation prevSourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)prevHandle);
            if (next instanceof ARETURN || (startLine = sourceLineAnnotation.getStartLine()) > 0 && lineMentionedMultipleTimes.get(startLine) && linesWithLoadsOfNotDefinitelyNullValues.get(startLine) || startLine > prevSourceLineAnnotation.getEndLine()) continue;
            int priority = 2;
            if (!v.isChecked()) {
                ++priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NP_LOAD_OF_KNOWN_NULL_VALUE", priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(sourceLineAnnotation));
        }
    }

    public void report() {
    }
}

