/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.List;

public class InstantiateStaticClass
extends BytecodeScanningDetector {
    private BugReporter bugReporter;

    public InstantiateStaticClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        try {
            if (seen == 183 && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V")) {
                XClass xClass = this.getXClassOperand();
                if (xClass == null) {
                    return;
                }
                String clsName = this.getClassConstantOperand();
                if (clsName.equals("java/lang/Object")) {
                    return;
                }
                if (this.getMethodName().equals("<init>") && this.getPC() == 1) {
                    return;
                }
                if (this.getMethodName().equals("<clinit>") && this.getClassName().equals(clsName)) {
                    return;
                }
                if (this.isStaticOnlyClass(xClass)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "ISC_INSTANTIATE_STATIC_CLASS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private boolean isStaticOnlyClass(XClass xClass) throws ClassNotFoundException {
        if (xClass.getInterfaceDescriptorList().length > 0) {
            return false;
        }
        ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
        if (superclassDescriptor == null) {
            return false;
        }
        String superClassName = superclassDescriptor.getClassName();
        if (!superClassName.equals("java/lang/Object")) {
            return false;
        }
        int staticCount = 0;
        List methods = xClass.getXMethods();
        for (XMethod m : methods) {
            if (m.isStatic()) {
                ++staticCount;
                continue;
            }
            if (m.getName().equals("<init>") && m.getSignature().equals("()V")) continue;
            return false;
        }
        List fields = xClass.getXFields();
        for (XField f : fields) {
            if (f.isStatic()) {
                ++staticCount;
                continue;
            }
            if (f.isPrivate()) continue;
            return false;
        }
        return staticCount != 0;
    }
}

