/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InheritanceUnsafeGetResource
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private boolean classIsFinal;
    private boolean classIsVisibleToOtherPackages;
    private boolean methodIsStatic;
    int state = 0;
    int sawGetClass;
    boolean reportedForThisClass;
    String stringConstant;
    int prevOpcode;

    public InheritanceUnsafeGetResource(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.classIsFinal = obj.isFinal();
        this.reportedForThisClass = false;
        this.classIsVisibleToOtherPackages = obj.isPublic() || obj.isProtected();
    }

    public void visit(Method obj) {
        this.methodIsStatic = obj.isStatic();
        this.state = 0;
        this.sawGetClass = -100;
    }

    public void sawOpcode(int seen) {
        if (this.reportedForThisClass) {
            return;
        }
        switch (seen) {
            case 18: {
                Constant constantValue = this.getConstantRefOperand();
                if (constantValue instanceof ConstantClass) {
                    this.sawGetClass = -100;
                    break;
                }
                if (!(constantValue instanceof ConstantString)) break;
                this.stringConstant = ((ConstantString)constantValue).getBytes(this.getConstantPool());
                break;
            }
            case 42: {
                this.state = 1;
                break;
            }
            case 182: {
                if (this.getClassConstantOperand().equals("java/lang/Class") && (this.getNameConstantOperand().equals("getResource") || this.getNameConstantOperand().equals("getResourceAsStream")) && this.sawGetClass + 10 >= this.getPC()) {
                    Subtypes subtypes = AnalysisContext.currentAnalysisContext().getSubtypes();
                    int priority = 2;
                    if (this.prevOpcode == 18 && this.stringConstant != null && this.stringConstant.charAt(0) == '/') {
                        priority = 3;
                    } else {
                        String myPackagename = this.getThisClass().getPackageName();
                        Set mySubtypes = subtypes.getTransitiveSubtypes(this.getThisClass());
                        if (mySubtypes.isEmpty()) {
                            ++priority;
                        } else {
                            for (JavaClass c : mySubtypes) {
                                if (c.getPackageName().equals(myPackagename)) continue;
                                --priority;
                                break;
                            }
                        }
                    }
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "UI_INHERITANCE_UNSAFE_GETRESOURCE", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.reportedForThisClass = true;
                } else if (this.state == 1 && !this.methodIsStatic && !this.classIsFinal && this.classIsVisibleToOtherPackages && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
                    this.sawGetClass = this.getPC();
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
        if (seen != 18) {
            this.stringConstant = null;
        }
        this.prevOpcode = seen;
    }
}

