/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;

public class CrossSiteScripting
extends OpcodeStackDetector {
    BugReporter bugReporter;
    BugAccumulator accumulator;
    Map<String, OpcodeStack.Item> map = new HashMap<String, OpcodeStack.Item>();
    OpcodeStack.Item top = null;

    public CrossSiteScripting(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code code) {
        super.visit(code);
        this.map.clear();
        this.accumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        if (seen == 185) {
            String calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            String calledMethodSig = this.getSigConstantOperand();
            if (calledClassName.equals("javax/servlet/http/HttpSession") && calledMethodName.equals("setAttribute")) {
                OpcodeStack.Item value = this.stack.getStackItem(0);
                OpcodeStack.Item name = this.stack.getStackItem(1);
                Object nameConstant = name.getConstant();
                if (nameConstant instanceof String) {
                    this.map.put((String)nameConstant, value);
                }
            } else if (calledClassName.equals("javax/servlet/http/HttpSession") && calledMethodName.equals("getAttribute")) {
                OpcodeStack.Item name = this.stack.getStackItem(0);
                Object nameConstant = name.getConstant();
                if (nameConstant instanceof String) {
                    this.top = this.map.get((String)nameConstant);
                }
            } else {
                this.top = null;
            }
        } else if (seen == 182) {
            String calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            String calledMethodSig = this.getSigConstantOperand();
            if (calledMethodName.startsWith("print") && calledClassName.equals("javax/servlet/jsp/JspWriter") && (calledMethodSig.equals("(Ljava/lang/Object;)V") || calledMethodSig.equals("(Ljava/lang/String;)V"))) {
                OpcodeStack.Item writing = this.stack.getStackItem(0);
                XMethod method = writing.getReturnValueOf();
                if (this.isTainted(writing)) {
                    this.accumulator.accumulateBug(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_JSP_WRITER", 1).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                } else if (this.isTainted(this.top)) {
                    this.accumulator.accumulateBug(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_JSP_WRITER", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                }
            } else if (calledMethodName.startsWith("print") && calledClassName.equals("java/io/PrintWriter") && (calledMethodSig.equals("(Ljava/lang/Object;)V") || calledMethodSig.equals("(Ljava/lang/String;)V"))) {
                OpcodeStack.Item writing = this.stack.getStackItem(0);
                OpcodeStack.Item writingTo = this.stack.getStackItem(1);
                if (this.isTainted(writing) && this.isServletWriter(writingTo)) {
                    this.accumulator.accumulateBug(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_SERVLET_WRITER", 1).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                } else if (this.isTainted(this.top) && this.isServletWriter(writingTo)) {
                    this.accumulator.accumulateBug(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_SERVLET_WRITER", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                }
            }
            this.top = null;
        } else {
            this.top = null;
        }
    }

    private boolean isTainted(OpcodeStack.Item writing) {
        if (writing == null) {
            return false;
        }
        XMethod method = writing.getReturnValueOf();
        return method != null && method.getName().equals("getParameter") && method.getClassName().equals("javax.servlet.http.HttpServletRequest");
    }

    private boolean isServletWriter(OpcodeStack.Item writingTo) {
        XMethod writingToSource = writingTo.getReturnValueOf();
        return writingToSource != null && writingToSource.getClassName().equals("javax.servlet.http.HttpServletResponse") && writingToSource.getName().equals("getWriter");
    }
}

