/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class BuildUnconditionalParamDerefDatabase {
    public static final boolean VERBOSE_DEBUG = SystemProperties.getBoolean((String)"fnd.debug.nullarg.verbose");
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fnd.debug.nullarg") || VERBOSE_DEBUG;
    protected int referenceParameters;
    protected int nonnullReferenceParameters;

    public void visitClassContext(ClassContext classContext) {
        boolean fullAnalysis = AnalysisContext.currentAnalysisContext().getBoolProperty(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES);
        if (!fullAnalysis && !AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(classContext.getJavaClass())) {
            return;
        }
        if (VERBOSE_DEBUG) {
            System.out.println("Visiting class " + classContext.getJavaClass().getClassName());
        }
        for (Method m : classContext.getMethodsInCallOrder()) {
            this.considerMethod(classContext, m);
        }
    }

    private void considerMethod(ClassContext classContext, Method method) {
        boolean hasReferenceParameters = false;
        for (Type argument : method.getArgumentTypes()) {
            if (!(argument instanceof ReferenceType)) continue;
            hasReferenceParameters = true;
            ++this.referenceParameters;
        }
        if (hasReferenceParameters && classContext.getMethodGen(method) != null) {
            if (VERBOSE_DEBUG) {
                System.out.println("Check " + method);
            }
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        try {
            CFG cfg = classContext.getCFG(method);
            ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
            UnconditionalValueDerefDataflow dataflow = classContext.getUnconditionalValueDerefDataflow(method);
            SignatureParser parser = new SignatureParser(method.getSignature());
            int paramLocalOffset = method.isStatic() ? 0 : 1;
            BitSet unconditionalDerefSet = new BitSet();
            UnconditionalValueDerefSet entryFact = (UnconditionalValueDerefSet)dataflow.getResultFact(cfg.getEntry());
            Iterator paramIterator = parser.parameterSignatureIterator();
            int i = 0;
            while (paramIterator.hasNext()) {
                String paramSig = (String)paramIterator.next();
                ValueNumber paramVN = ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getEntryValue(paramLocalOffset);
                if (entryFact.isUnconditionallyDereferenced(paramVN)) {
                    unconditionalDerefSet.set(i);
                }
                ++i;
                if (paramSig.equals("D") || paramSig.equals("J")) {
                    paramLocalOffset += 2;
                    continue;
                }
                ++paramLocalOffset;
            }
            if (unconditionalDerefSet.isEmpty()) {
                if (VERBOSE_DEBUG) {
                    System.out.println("\tResult is empty");
                }
                return;
            }
            if (VERBOSE_DEBUG) {
                ClassContext.dumpDataflowInformation((Method)method, (CFG)cfg, (ValueNumberDataflow)vnaDataflow, (IsNullValueDataflow)classContext.getIsNullValueDataflow(method), (UnconditionalValueDerefDataflow)dataflow, (TypeDataflow)classContext.getTypeDataflow(method));
            }
            ParameterNullnessProperty property = new ParameterNullnessProperty();
            this.nonnullReferenceParameters += unconditionalDerefSet.cardinality();
            property.setNonNullParamSet(unconditionalDerefSet);
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase().setProperty((FieldOrMethodDescriptor)xmethod.getMethodDescriptor(), (Object)property);
            if (DEBUG) {
                System.out.println("Unconditional deref: " + xmethod + "=" + property);
            }
        }
        catch (CheckedAnalysisException e) {
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + xmethod + " for unconditional deref training", (Throwable)e);
        }
    }
}

