/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCheckReturnAnnotationDatabase
extends AnnotationVisitor {
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private static final Map<String, AnnotationDatabase.Target> defaultKind = new HashMap<String, AnnotationDatabase.Target>();

    static String lastPortion(String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        CheckReturnValueAnnotation n = CheckReturnValueAnnotation.parse((String)(annotationClass = BuildCheckReturnAnnotationDatabase.lastPortion(annotationClass)), (String)((String)map.get("priority")));
        if (n == null) {
            if (annotationClass.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
                Object v = map.get("value");
                if (v == null || !(v instanceof Object[])) {
                    return;
                }
                AnnotationDatabase.Target annotationTarget = defaultKind.get(annotationClass = annotationClass.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
                if (annotationTarget != null) {
                    for (Object aClass : (Object[])v) {
                        n = CheckReturnValueAnnotation.parse((String)((String)aClass), (String)((String)map.get("priority")));
                        if (n == null) continue;
                        AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDefaultAnnotation(annotationTarget, this.getDottedClassName(), (AnnotationEnumeration)n);
                    }
                }
            }
        } else if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDirectAnnotation((Object)XFactory.createXMethod((PreorderVisitor)this), (AnnotationEnumeration)n);
        }
    }

    static {
        defaultKind.put("", AnnotationDatabase.Target.ANY);
        defaultKind.put("ForParameters", AnnotationDatabase.Target.PARAMETER);
        defaultKind.put("ForMethods", AnnotationDatabase.Target.METHOD);
        defaultKind.put("ForFields", AnnotationDatabase.Target.FIELD);
    }
}

