/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.IOException;
import java.util.Iterator;

public class UnionResults {
    public static SortedBugCollection union(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        SortedBugCollection result = origCollection.duplicate();
        Iterator<BugInstance> i = newCollection.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = i.next();
            result.add(bugInstance);
        }
        ProjectStats stats = result.getProjectStats();
        ProjectStats stats2 = newCollection.getProjectStats();
        stats.addStats(stats2);
        return result;
    }

    public static void main(String[] argv) throws Exception {
        UnionResultsCommandLine commandLine = new UnionResultsCommandLine();
        int argCount = commandLine.parse(argv, 2, Integer.MAX_VALUE, "Usage: " + UnionResults.class.getName() + " [options] [<results1> <results2> ... <resultsn>] ");
        SortedBugCollection results = new SortedBugCollection();
        Project project = new Project();
        results.readXML(argv[argCount++], project);
        for (int i = argCount; i < argv.length; ++i) {
            try {
                SortedBugCollection more = new SortedBugCollection();
                Project newProject = new Project();
                more.readXML(argv[i], newProject);
                project.add(newProject);
                results = UnionResults.union(results, more);
                continue;
            }
            catch (Exception e) {
                System.err.println("Trouble parsing " + argv[i]);
                e.printStackTrace();
            }
        }
        results.setWithMessages(commandLine.withMessages);
        if (commandLine.outputFile == null) {
            results.writeXML(System.out, project);
        } else {
            results.writeXML(commandLine.outputFile, project);
        }
    }

    static {
        DetectorFactoryCollection.instance();
    }

    static class UnionResultsCommandLine
    extends CommandLine {
        public String outputFile;
        boolean withMessages;

        UnionResultsCommandLine() {
            this.addSwitch("-withMessages", "Generated XML should contain msgs for external processing");
            this.addOption("-output", "outputFile", "File in which to store combined results");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (!option.equals("-withMessages")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.withMessages = true;
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (!option.equals("-output")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.outputFile = argument;
        }
    }
}

