/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;

public class FileBugHash {
    public static void main(String[] args) throws Exception {
        if (args.length > 1 || args.length > 0 && "-help".equals(args[0])) {
            System.err.println("Usage: " + FileBugHash.class.getName() + " [<infile>]");
            System.exit(1);
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        int argCount = 0;
        if (argCount == args.length) {
            origCollection.readXML(System.in, project);
        } else {
            origCollection.readXML(args[argCount], project);
        }
        TreeMap<String, StringBuffer> map = new TreeMap<String, StringBuffer>();
        for (BugInstance bugInstance : origCollection.getCollection()) {
            String key;
            StringBuffer buf;
            SourceLineAnnotation source = bugInstance.getPrimarySourceLineAnnotation();
            ClassAnnotation classAnnotation = bugInstance.getPrimaryClass();
            MethodAnnotation methodAnnotation = bugInstance.getPrimaryMethod();
            FieldAnnotation fieldAnnotation = bugInstance.getPrimaryField();
            if (!source.isSourceFileKnown()) {
                System.out.println(bugInstance);
                System.out.println(classAnnotation);
                System.out.println(fieldAnnotation);
                System.out.println(methodAnnotation);
                source = bugInstance.getPrimarySourceLineAnnotation();
            }
            if ((buf = (StringBuffer)map.get(key = source.getPackageName().replace('.', '/') + "/" + source.getSourceFile())) == null) {
                buf = new StringBuffer();
                map.put(key, buf);
            }
            buf.append(bugInstance.getInstanceKey()).append("-").append(source.getStartLine()).append(".").append(source.getStartBytecode()).append(" ");
        }
        for (Map.Entry entry : map.entrySet()) {
            byte[] data = digest.digest(((StringBuffer)entry.getValue()).toString().getBytes());
            String tmp = new BigInteger(1, data).toString(16);
            if (tmp.length() < 32) {
                tmp = "000000000000000000000000000000000".substring(0, 32 - tmp.length()) + tmp;
            }
            System.out.println(tmp + "\t" + (String)entry.getKey());
        }
    }
}

