/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class LocalMatcher
implements Matcher {
    private NameMatch name;

    public LocalMatcher(String name) {
        this.name = new NameMatch(name);
    }

    public LocalMatcher(String name, String type) {
        this.name = new NameMatch(name);
    }

    public String toString() {
        return "Local(name=" + this.name + ")";
    }

    public boolean match(BugInstance bugInstance) {
        LocalVariableAnnotation localAnnotation = bugInstance.getPrimaryLocalVariableAnnotation();
        if (localAnnotation == null) {
            return false;
        }
        return this.name.match(localAnnotation.getName());
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.name.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Local", attributes);
    }
}

