/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodGenFactory
extends AnalysisFactory<MethodGen> {
    public MethodGenFactory() {
        super("MethodGen construction", MethodGen.class);
    }

    @Override
    public MethodGen analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        Method method = this.getMethod(analysisCache, descriptor);
        if (method.getCode() == null) {
            return null;
        }
        try {
            int codeLength;
            AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
            JavaClass jclass = this.getJavaClass(analysisCache, descriptor.getClassDescriptor());
            ConstantPoolGen cpg = this.getConstantPoolGen(analysisCache, descriptor.getClassDescriptor());
            String methodName = method.getName();
            if (analysisContext.getBoolProperty(3) && ((codeLength = method.getCode().getLength()) > 3000 || (methodName.equals("<clinit>") || methodName.equals("getContents")) && codeLength > 1000)) {
                analysisContext.getLookupFailureCallback().reportSkippedAnalysis(new JavaClassAndMethod(jclass, method).toMethodDescriptor());
                return null;
            }
            return new MethodGen(method, jclass.getClassName(), cpg);
        }
        catch (Exception e) {
            AnalysisContext.logError("Error constructing methodGen", e);
            return null;
        }
    }
}

