/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.analysis;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
extends FieldDescriptor
implements XField,
AnnotatedObject {
    final int accessFlags;
    @CheckForNull
    final String fieldSourceSignature;
    Map<ClassDescriptor, AnnotationValue> fieldAnnotations;
    final boolean isResolved;

    private FieldInfo(@SlashedClassName String className, String fieldName, String fieldSignature, @CheckForNull String fieldSourceSignature, int accessFlags, Map<ClassDescriptor, AnnotationValue> fieldAnnotations, boolean isResolved) {
        super(className, fieldName, fieldSignature, (accessFlags & 8) != 0);
        this.accessFlags = accessFlags | (fieldName.startsWith("this$") ? 16 : 0);
        this.fieldSourceSignature = fieldSourceSignature;
        this.fieldAnnotations = Util.immutableMap(fieldAnnotations);
        this.isResolved = isResolved;
    }

    public int getNumParams() {
        return new SignatureParser(this.getSignature()).getNumParameters();
    }

    private boolean checkFlag(int flag) {
        return (this.accessFlags & flag) != 0;
    }

    public boolean isNative() {
        return this.checkFlag(256);
    }

    public boolean isSynchronized() {
        return this.checkFlag(32);
    }

    @Override
    public boolean isDeprecated() {
        return this.checkFlag(131072);
    }

    @Override
    @DottedClassName
    public String getClassName() {
        return this.getClassDescriptor().toDottedClassName();
    }

    @Override
    @DottedClassName
    public String getPackageName() {
        return this.getClassDescriptor().getPackageName();
    }

    public String getSourceSignature() {
        return this.fieldSourceSignature;
    }

    public int compareTo(Object rhs) {
        if (rhs instanceof FieldDescriptor) {
            return super.compareTo((FieldDescriptor)rhs);
        }
        if (rhs instanceof XField) {
            return XFactory.compare(this, (XField)rhs);
        }
        throw new ClassCastException("Can't compare a " + this.getClass().getName() + " to a " + rhs.getClass().getName());
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public boolean isFinal() {
        return this.checkFlag(16);
    }

    @Override
    public boolean isPrivate() {
        return this.checkFlag(2);
    }

    @Override
    public boolean isProtected() {
        return this.checkFlag(4);
    }

    @Override
    public boolean isPublic() {
        return this.checkFlag(1);
    }

    @Override
    public boolean isResolved() {
        return this.isResolved;
    }

    @Override
    public boolean isReferenceType() {
        return this.getSignature().startsWith("L") || this.getSignature().startsWith("[");
    }

    @Override
    public boolean isVolatile() {
        return this.checkFlag(64);
    }

    @Override
    public boolean isSynthetic() {
        return this.checkFlag(4096);
    }

    @Override
    public Collection<ClassDescriptor> getAnnotationDescriptors() {
        return this.fieldAnnotations.keySet();
    }

    @Override
    public AnnotationValue getAnnotation(ClassDescriptor desc) {
        return this.fieldAnnotations.get(desc);
    }

    @Override
    public Collection<AnnotationValue> getAnnotations() {
        return this.fieldAnnotations.values();
    }

    public void addAnnotation(AnnotationValue annotationValue) {
        HashMap<ClassDescriptor, AnnotationValue> updatedAnnotations = new HashMap<ClassDescriptor, AnnotationValue>(this.fieldAnnotations);
        updatedAnnotations.put(annotationValue.getAnnotationClass(), annotationValue);
        this.fieldAnnotations = updatedAnnotations;
    }

    @Override
    public FieldDescriptor getFieldDescriptor() {
        return this;
    }

    public static FieldInfo createUnresolvedFieldInfo(String className, String name, String signature, boolean isStatic) {
        className = ClassName.toSlashedClassName(className);
        return new FieldInfo(className, name, signature, null, isStatic ? 8 : 0, new HashMap<ClassDescriptor, AnnotationValue>(), false);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    @CheckForNull
    public AnnotatedObject getContainingScope() {
        try {
            return (ClassInfo)Global.getAnalysisCache().getClassAnalysis(XClass.class, this.getClassDescriptor());
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    public static class Builder {
        final int accessFlags;
        final String className;
        final String fieldName;
        final String fieldSignature;
        String fieldSourceSignature;
        final Map<ClassDescriptor, AnnotationValue> fieldAnnotations = new HashMap<ClassDescriptor, AnnotationValue>();

        public Builder(@SlashedClassName String className, String fieldName, String fieldSignature, int accessFlags) {
            this.className = className;
            this.fieldName = fieldName;
            this.fieldSignature = fieldSignature;
            this.accessFlags = accessFlags;
        }

        public void setSourceSignature(String fieldSourceSignature) {
            this.fieldSourceSignature = fieldSourceSignature;
        }

        public void addAnnotation(String name, AnnotationValue value) {
            ClassDescriptor annotationClass = DescriptorFactory.createClassDescriptorFromSignature(name);
            this.fieldAnnotations.put(annotationClass, value);
        }

        public FieldInfo build() {
            return new FieldInfo(this.className, this.fieldName, this.fieldSignature, this.fieldSourceSignature, this.accessFlags, this.fieldAnnotations, true);
        }
    }
}

