/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import java.util.LinkedList;

public class PolicyDatabase {
    public static final int ADD = 0;
    public static final int DEL = 1;
    private LinkedList<Entry> entryList = new LinkedList();

    public void addEntry(String className, String methodName, String signature, boolean isStatic, int action, Obligation obligation) {
        this.entryList.add(new Entry(className, methodName, signature, isStatic, action, obligation));
    }

    public Obligation lookup(String className, String methodName, String signature, boolean isStatic, int action) throws ClassNotFoundException {
        for (Entry entry : this.entryList) {
            if (isStatic != entry.isStatic() || action != entry.getAction() || !methodName.equals(entry.getMethodName()) || !signature.equals(entry.getSignature()) || !Hierarchy.isSubtype(className, entry.getClassName())) continue;
            return entry.getObligation();
        }
        return null;
    }

    private static class Entry {
        private final String className;
        private final String methodName;
        private final String signature;
        private final boolean isStatic;
        private final int action;
        private final Obligation obligation;

        public Entry(String className, String methodName, String signature, boolean isStatic, int action, Obligation obligation) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.isStatic = isStatic;
            this.action = action;
            this.obligation = obligation;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public int getAction() {
            return this.action;
        }

        public Obligation getObligation() {
            return this.obligation;
        }
    }
}

