/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import edu.umd.cs.findbugs.util.Util;

public class TypeQualifierValue {
    private static final boolean DEBUG = SystemProperties.getBoolean("tqv.debug");
    public final ClassDescriptor typeQualifier;
    @CheckForNull
    public final Object value;
    private boolean isStrict;
    private static DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue> map = new DualKeyHashMap();

    private TypeQualifierValue(ClassDescriptor typeQualifier, @CheckForNull Object value) {
        this.typeQualifier = typeQualifier;
        this.value = value;
        this.isStrict = false;
    }

    @NonNull
    public static synchronized TypeQualifierValue getValue(ClassDescriptor desc, Object value) {
        TypeQualifierValue result = map.get(desc, value);
        if (result != null) {
            return result;
        }
        result = new TypeQualifierValue(desc, value);
        TypeQualifierValue.determineIfQualifierIsStrict(desc, result);
        map.put(desc, value, result);
        return result;
    }

    private static void determineIfQualifierIsStrict(ClassDescriptor desc, TypeQualifierValue result) {
        if (DEBUG) {
            System.out.print("Checking to see if " + desc + " requires strict checking...");
        }
        try {
            XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, desc);
            XMethod whenMethod = xclass.findMethod("when", "()Ljavax/annotation/meta/When;", false);
            if (whenMethod == null) {
                result.setIsStrict();
            }
        }
        catch (MissingClassException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error looking up annotation class " + desc.toDottedClassName(), e);
        }
        if (DEBUG) {
            System.out.println(result.isStrictQualifier() ? "yes" : "no");
        }
    }

    public ClassDescriptor getTypeQualifierClassDescriptor() {
        return this.typeQualifier;
    }

    private void setIsStrict() {
        this.isStrict = true;
    }

    public boolean isStrictQualifier() {
        return this.isStrict;
    }

    public int hashCode() {
        int result = this.typeQualifier.hashCode();
        if (this.value != null) {
            result += 37 * this.value.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeQualifierValue)) {
            return false;
        }
        TypeQualifierValue other = (TypeQualifierValue)o;
        return this.typeQualifier.equals(other.typeQualifier) && Util.nullSafeEquals(this.value, other.value);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.typeQualifier.toString());
        if (this.value != null) {
            buf.append(':');
            buf.append(this.value.toString());
        }
        return buf.toString();
    }
}

