/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ch;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Subtypes {
    private static final boolean DEBUG_HIERARCHY = SystemProperties.getBoolean("findbugs.debug.hierarchy");

    public Set<JavaClass> getImmediateSubtypes(JavaClass c) {
        ClassDescriptor classDescriptor = DescriptorFactory.createClassDescriptor(c);
        try {
            return this.getJavaClasses(Subtypes.subtypes2().getSubtypes(classDescriptor));
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return Collections.emptySet();
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error checking subtypes of " + c.getClassName(), e);
            return Collections.emptySet();
        }
    }

    private JavaClass getJavaClass(ClassDescriptor descriptor) throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(JavaClass.class, descriptor);
    }

    private JavaClass getJavaClass(XClass xClass) throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(JavaClass.class, xClass.getClassDescriptor());
    }

    private Set<JavaClass> getJavaClasses(Collection<ClassDescriptor> descriptors) throws CheckedAnalysisException {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        for (ClassDescriptor c : descriptors) {
            result.add(this.getJavaClass(c));
        }
        return result;
    }

    private Set<JavaClass> getJavaClassesFromXClasses(Collection<XClass> xclasses) throws CheckedAnalysisException {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        for (XClass c : xclasses) {
            result.add(this.getJavaClass(c));
        }
        return result;
    }

    private static Subtypes2 subtypes2() {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        return analysisContext.getSubtypes2();
    }

    public boolean hasSubtypes(JavaClass c) {
        ClassDescriptor classDescriptor = DescriptorFactory.createClassDescriptor(c);
        try {
            return !Subtypes.subtypes2().getDirectSubtypes(classDescriptor).isEmpty();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    @Deprecated
    public Set<JavaClass> getAllClasses() {
        assert (false);
        try {
            return this.getJavaClassesFromXClasses(Subtypes.subtypes2().getXClassCollection());
        }
        catch (CheckedAnalysisException e) {
            throw new AssertionError((Object)"We're screwed");
        }
    }

    public Set<JavaClass> getTransitiveSubtypes(JavaClass c) {
        assert (!c.getClassName().equals("java.lang.Object"));
        ClassDescriptor classDescriptor = DescriptorFactory.createClassDescriptor(c);
        try {
            return this.getJavaClasses(Subtypes.subtypes2().getSubtypes(classDescriptor));
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return Collections.emptySet();
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error checking subtypes of " + c.getClassName(), e);
            return Collections.emptySet();
        }
    }

    public Set<JavaClass> getTransitiveCommonSubtypes(JavaClass a, JavaClass b) {
        ClassDescriptor aD = DescriptorFactory.createClassDescriptor(a);
        ClassDescriptor bD = DescriptorFactory.createClassDescriptor(b);
        try {
            return this.getJavaClasses(Subtypes.subtypes2().getTransitiveCommonSubtypes(aD, bD));
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return Collections.emptySet();
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error checking common subtypes of " + a.getClassName() + " and " + b.getClassName(), e);
            return Collections.emptySet();
        }
    }

    public static void learnFieldsAndMethods(JavaClass c) {
        for (Field field : c.getFields()) {
            XFactory.createXField(c, field);
        }
        for (FieldOrMethod fieldOrMethod : c.getMethods()) {
            XFactory.createXMethod(c, (Method)fieldOrMethod);
        }
    }

    @Deprecated
    public void addNamedClass(String name) {
    }

    @Deprecated
    public void addApplicationClass(JavaClass c) {
    }

    @Deprecated
    public void addClass(JavaClass c) {
    }

    public static String extractClassName(String originalName) {
        String name = originalName;
        if (name.charAt(0) != '[' && name.charAt(name.length() - 1) != ';') {
            return name;
        }
        while (name.charAt(0) == '[') {
            name = name.substring(1);
        }
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        if (name.charAt(0) == '[') {
            throw new IllegalArgumentException("Bad class name: " + originalName);
        }
        return name;
    }

    public boolean isApplicationClass(JavaClass javaClass) {
        return Subtypes.subtypes2().isApplicationClass(DescriptorFactory.createClassDescriptor(javaClass));
    }
}

