/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ca;

import edu.umd.cs.findbugs.ba.ca.Call;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallList {
    private boolean isTop;
    private boolean isBottom;
    private ArrayList<Call> callList = new ArrayList();

    public boolean isValid() {
        return !this.isTop() && !this.isBottom();
    }

    public Iterator<Call> callIterator() {
        return this.callList.iterator();
    }

    public boolean isTop() {
        return this.isTop;
    }

    public boolean isBottom() {
        return this.isBottom;
    }

    public void setTop() {
        this.isTop = true;
        this.isBottom = false;
        this.callList.clear();
    }

    public void setBottom() {
        this.isTop = false;
        this.isBottom = true;
        this.callList.clear();
    }

    public void clear() {
        this.isBottom = false;
        this.isTop = false;
        this.callList.clear();
    }

    public void add(Call call) {
        this.callList.add(call);
    }

    public int size() {
        return this.callList.size();
    }

    public Call get(int index) {
        return this.callList.get(index);
    }

    public void copyFrom(CallList other) {
        this.isTop = other.isTop;
        this.isBottom = other.isBottom;
        this.callList.clear();
        this.callList.addAll(other.callList);
    }

    public static CallList merge(CallList a, CallList b) {
        CallList result = new CallList();
        if (a.isBottom || b.isBottom) {
            result.isBottom = true;
        } else if (a.isTop) {
            result.copyFrom(b);
        } else if (b.isTop) {
            result.copyFrom(a);
        } else {
            int len = Math.min(a.size(), b.size());
            for (int i = 0; i < len && a.get(i).equals(b.get(i)); ++i) {
                result.add(a.get(i));
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CallList other = (CallList)obj;
        return this.callList.equals(other.callList);
    }

    public int hashCode() {
        return this.callList.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Call call : this.callList) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(call.getMethodName());
        }
        return buf.toString();
    }
}

