/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.graph.AbstractEdge;
import java.util.Locale;
import java.util.Set;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge
extends AbstractEdge<Edge, BasicBlock>
implements EdgeTypes,
Debug {
    private int type;
    private int flags;

    public Edge(BasicBlock source, BasicBlock dest) {
        super(source, dest);
    }

    public int getId() {
        return this.getLabel();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean isExceptionEdge() {
        return this.type == 9 || this.type == 8;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge other = (Edge)o;
        return this.getSource() == other.getSource() && this.getTarget() == other.getTarget() && this.getType() == other.getType();
    }

    @Override
    public int hashCode() {
        return 2003 * ((BasicBlock)this.getSource()).getLabel() + ((BasicBlock)this.getTarget()).getLabel();
    }

    @Override
    public int compareTo(Edge other) {
        int cmp = super.compareTo(other);
        if (cmp != 0) {
            return cmp;
        }
        return this.type - other.type;
    }

    public String toString() {
        return this.formatAsString(false);
    }

    public boolean isBackwardInBytecode() {
        BasicBlock source = (BasicBlock)this.getSource();
        BasicBlock target = (BasicBlock)this.getTarget();
        InstructionHandle sourceInstruction = source.getLastInstruction();
        InstructionHandle targetInstruction = target.getFirstInstruction();
        if (targetInstruction == null || sourceInstruction == null) {
            return false;
        }
        return targetInstruction.getPosition() < sourceInstruction.getPosition();
    }

    public boolean sourceIsTopOfLoop(Set<Integer> positions) {
        BasicBlock source = (BasicBlock)this.getSource();
        InstructionHandle sourceInstruction = source.getLastInstruction();
        if (sourceInstruction == null) {
            return false;
        }
        return positions.contains(sourceInstruction.getPosition());
    }

    public String formatAsString(boolean reverse) {
        BasicBlock source = (BasicBlock)this.getSource();
        BasicBlock target = (BasicBlock)this.getTarget();
        StringBuffer buf = new StringBuffer();
        buf.append(reverse ? "REVERSE_EDGE(" : "EDGE(");
        buf.append(this.getLabel());
        buf.append(") type ");
        buf.append(Edge.edgeTypeToString(this.type));
        buf.append(" from block ");
        buf.append(reverse ? target.getLabel() : source.getLabel());
        buf.append(" to block ");
        buf.append(reverse ? source.getLabel() : target.getLabel());
        InstructionHandle sourceInstruction = source.getLastInstruction();
        InstructionHandle targetInstruction = target.getFirstInstruction();
        String exInfo = " -> ";
        if (targetInstruction == null && target.isExceptionThrower()) {
            targetInstruction = target.getExceptionThrower();
            exInfo = " => ";
        }
        if (sourceInstruction != null && targetInstruction != null) {
            buf.append(" [bytecode ");
            buf.append(sourceInstruction.getPosition());
            buf.append(exInfo);
            buf.append(targetInstruction.getPosition());
            buf.append(']');
        } else if (source.isExceptionThrower()) {
            if (this.type == 0) {
                buf.append(" [successful check]");
            } else {
                buf.append(" [failed check for ");
                buf.append(source.getExceptionThrower().getPosition());
                if (targetInstruction != null) {
                    buf.append(" to ");
                    buf.append(targetInstruction.getPosition());
                }
                buf.append(']');
            }
        }
        return buf.toString();
    }

    public static String edgeTypeToString(int edgeType) {
        switch (edgeType) {
            case 0: {
                return "FALL_THROUGH";
            }
            case 1: {
                return "IFCMP";
            }
            case 2: {
                return "SWITCH";
            }
            case 3: {
                return "SWITCH_DEFAULT";
            }
            case 4: {
                return "JSR";
            }
            case 5: {
                return "RET";
            }
            case 6: {
                return "GOTO";
            }
            case 7: {
                return "RETURN";
            }
            case 8: {
                return "UNHANDLED_EXCEPTION";
            }
            case 9: {
                return "HANDLED_EXCEPTION";
            }
            case 10: {
                return "START";
            }
            case 11: {
                return "BACKEDGE_TARGET_EDGE";
            }
            case 12: {
                return "BACKEDGE_SOURCE_EDGE";
            }
            case 13: {
                return "EXIT_EDGE";
            }
        }
        throw new IllegalStateException("unknown edge type: " + edgeType);
    }

    public static int stringToEdgeType(String s) {
        if ((s = s.toUpperCase(Locale.ENGLISH)).equals("FALL_THROUGH")) {
            return 0;
        }
        if (s.equals("IFCMP")) {
            return 1;
        }
        if (s.equals("SWITCH")) {
            return 2;
        }
        if (s.equals("SWITCH_DEFAULT")) {
            return 3;
        }
        if (s.equals("JSR")) {
            return 4;
        }
        if (s.equals("RET")) {
            return 5;
        }
        if (s.equals("GOTO")) {
            return 6;
        }
        if (s.equals("RETURN")) {
            return 7;
        }
        if (s.equals("UNHANDLED_EXCEPTION")) {
            return 8;
        }
        if (s.equals("HANDLED_EXCEPTION")) {
            return 9;
        }
        if (s.equals("START")) {
            return 10;
        }
        if (s.equals("BACKEDGE_TARGET_EDGE")) {
            return 11;
        }
        if (s.equals("BACKEDGE_SOURCE_EDGE")) {
            return 12;
        }
        if (s.equals("EXIT_EDGE")) {
            return 13;
        }
        throw new IllegalArgumentException("Unknown edge type: " + s);
    }
}

