/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractDataflowTestDriver;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.DebugRepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.RepositoryClassParser;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataflowTestDriver<Fact, AnalysisType extends BasicAbstractDataflowAnalysis<Fact>>
extends AbstractDataflowTestDriver {
    public void execute(String filename) throws DataflowAnalysisException, CFGBuilderException, IOException {
        Method[] methods;
        JavaClass jclass = new RepositoryClassParser(filename).parse();
        DebugRepositoryLookupFailureCallback lookupFailureCallback = new DebugRepositoryLookupFailureCallback();
        AnalysisContext analysisContext = AnalysisContext.create(lookupFailureCallback);
        analysisContext.setBoolProperty(0, true);
        this.configureAnalysisContext(analysisContext);
        ClassContext classContext = analysisContext.getClassContext(jclass);
        String methodName = SystemProperties.getProperty("dataflow.method");
        for (Method method : methods = jclass.getMethods()) {
            MethodGen methodGen;
            if (methodName != null && !method.getName().equals(methodName) || (methodGen = classContext.getMethodGen(method)) == null) continue;
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Method: " + SignatureConverter.convertMethodSignature(methodGen));
            System.out.println("-----------------------------------------------------------------");
            this.execute(classContext, method);
        }
    }

    public void execute(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        Dataflow<Fact, AnalysisType> dataflow = this.createDataflow(classContext, method);
        System.out.println("Finished in " + dataflow.getNumIterations() + " iterations");
        CFG cfg = classContext.getCFG(method);
        this.examineResults(cfg, dataflow);
        if (SystemProperties.getBoolean("dataflow.printcfg")) {
            DataflowCFGPrinter<Fact, AnalysisType> p = new DataflowCFGPrinter<Fact, AnalysisType>(dataflow);
            if (this.overrideIsForwards) {
                p.setIsForwards(!p.isForwards());
            }
            p.print(System.out);
        }
    }

    public abstract Dataflow<Fact, AnalysisType> createDataflow(ClassContext var1, Method var2) throws CFGBuilderException, DataflowAnalysisException;

    public void examineResults(CFG cfg, Dataflow<Fact, AnalysisType> dataflow) {
    }
}

