/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckReturnAnnotationDatabase
extends AnnotationDatabase<CheckReturnValueAnnotation> {
    private JavaClass throwableClass;
    private JavaClass threadClass;

    public CheckReturnAnnotationDatabase() {
        this.setAddClassOnly(true);
        this.loadAuxiliaryAnnotations();
        this.setAddClassOnly(false);
    }

    @Override
    public void loadAuxiliaryAnnotations() {
        if (IGNORE_BUILTIN_ANNOTATIONS) {
            return;
        }
        boolean missingClassWarningsSuppressed = AnalysisContext.currentAnalysisContext().setMissingClassWarningsSuppressed(true);
        this.addMethodAnnotation("java.util.Iterator", "hasNext", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation("java.io.File", "createNewFile", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "delete", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "mkdir", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "mkdirs", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "renameTo", "(Ljava/io/File;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "setLastModified", "(J)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "setReadOnly", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.io.File", "setWritable", "(ZZ)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.Enumeration", "hasMoreElements", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.security.MessageDigest", "digest", "([B)[B", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.util.concurrent.locks.ReadWriteLock", "readLock", "()Ljava/util/concurrent/locks/Lock;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.locks.ReadWriteLock", "writeLock", "()Ljava/util/concurrent/locks/Lock;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.locks.Condition", "await", "(JLjava/util/concurrent/TimeUnit;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.locks.Condition", "awaitUtil", "(Ljava/util/Date;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.locks.Condition", "awaitNanos", "(J)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.Semaphore", "tryAcquire", "(JLjava/util/concurrent/TimeUnit;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.Semaphore", "tryAcquire", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.locks.Lock", "tryLock", "(JLjava/util/concurrent/TimeUnit;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.locks.Lock", "newCondition", "()Ljava/util/concurrent/locks/Condition;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.locks.Lock", "tryLock", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.BlockingQueue", "offer", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.ConcurrentLinkedQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.DelayQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.LinkedBlockingQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.LinkedList", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.Queue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.ArrayBlockingQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.SynchronousQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.PriorityQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.PriorityBlockingQueue", "offer", "(Ljava/lang/Object;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.concurrent.BlockingQueue", "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.util.Queue", "poll", "()Ljava/lang/Object;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addDefaultMethodAnnotation("java.lang.String", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.lang.String", "getBytes", "(Ljava/lang/String;)[B", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.lang.String", "charAt", "(I)C", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation("java.lang.String", "length", "()I", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation("java.lang.String", "<init>", "([BLjava/lang/String;)V", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.lang.String", "<init>", "(Ljava/lang/String;)V", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation("java.lang.String", "<init>", "()V", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addDefaultMethodAnnotation("java.math.BigDecimal", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.math.BigDecimal", "inflate", "()Ljava/math/BigDecimal;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addDefaultMethodAnnotation("java.math.BigInteger", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.math.BigInteger", "addOne", "([IIII)I", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.math.BigInteger", "subN", "([I[II)I", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addDefaultMethodAnnotation("java.sql.Connection", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addDefaultMethodAnnotation("java.net.InetAddress", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.util.InetAddress", "getByName", "(Ljava/lang/String;)Ljava/util/InetAddress;", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.lang.ProcessBuilder", "redirectErrorStream", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        AnalysisContext.currentAnalysisContext().setMissingClassWarningsSuppressed(missingClassWarningsSuppressed);
        try {
            this.throwableClass = Repository.lookupClass("java.lang.Throwable");
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        try {
            this.threadClass = Repository.lookupClass("java.lang.Thread");
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    @Override
    public CheckReturnValueAnnotation getResolvedAnnotation(Object o, boolean getMinimal) {
        if (!(o instanceof XMethod)) {
            return null;
        }
        XMethod m = (XMethod)o;
        if (m.getName().startsWith("access$")) {
            return null;
        }
        if (m.getName().equals("<init>")) {
            try {
                if (this.throwableClass != null && Repository.instanceOf(m.getClassName(), this.throwableClass)) {
                    return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_VERY_HIGH;
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
            if (m.getClassName().equals("java.lang.Thread")) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_VERY_HIGH;
            }
            try {
                if (this.threadClass != null && Repository.instanceOf(m.getClassName(), this.threadClass)) {
                    return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW;
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        } else {
            if (m.getName().equals("equals") && m.getSignature().equals("(Ljava/lang/Object;)Z") && !m.isStatic()) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
            }
            if (m.getSignature().endsWith(")Ljava/lang/String;") && (m.getClassName().equals("java.lang.StringBuffer") || m.getClassName().equals("java.lang.StringBuilder"))) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
            }
        }
        return (CheckReturnValueAnnotation)super.getResolvedAnnotation(o, getMinimal);
    }
}

