/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class StringAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ROLE = "STRING_DEFAULT";
    private final String value;
    private String description;
    private static final String ELEMENT_NAME = "String";

    public StringAnnotation(String value) {
        this.value = StringAnnotation.quoteCharacters(value);
        this.description = DEFAULT_ROLE;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String quoteCharacters(String s) {
        StringBuffer result = null;
        int max = s.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            String replacement = null;
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\'') {
                replacement = "&apos;";
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public String getValue() {
        return this.value;
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitStringAnnotation(this);
    }

    public String format(String key, ClassAnnotation primaryClass) {
        return this.value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringAnnotation)) {
            return false;
        }
        return this.value.equals(((StringAnnotation)o).value);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof StringAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.value.compareTo(((StringAnnotation)o).value);
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("value", this.value);
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    public boolean isSignificant() {
        return true;
    }
}

