/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.FieldAnnotation;

public class FieldWarningSuppressor
extends ClassWarningSuppressor {
    FieldAnnotation field;

    public FieldWarningSuppressor(String bugPattern, ClassAnnotation clazz, FieldAnnotation field) {
        super(bugPattern, clazz);
        this.field = field;
    }

    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        FieldAnnotation bugField = bugInstance.getPrimaryField();
        if (bugField != null && !this.field.equals(bugField)) {
            return false;
        }
        if (DEBUG) {
            System.out.println("Suppressing " + bugInstance);
        }
        return true;
    }
}

