/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludingHashesBugReporter
extends DelegatingBugReporter {
    Set<String> excludedHashes = new HashSet<String>();

    public ExcludingHashesBugReporter(BugReporter delegate, String baseline) throws IOException, DocumentException {
        super(delegate);
        ExcludingHashesBugReporter.addToExcludedInstanceHashes(this.excludedHashes, baseline);
    }

    public static void addToExcludedInstanceHashes(Set<String> instanceHashesToExclude, String baseline) throws IOException, DocumentException {
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        origCollection.readXML(baseline, project);
        for (BugInstance b : origCollection.getCollection()) {
            instanceHashesToExclude.add(b.getInstanceHash());
        }
    }

    @Override
    public void reportBug(BugInstance bugInstance) {
        String instanceHash = bugInstance.getInstanceHash();
        if (!this.excludedHashes.contains(instanceHash)) {
            this.getDelegate().reportBug(bugInstance);
        }
    }
}

