/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.security.MessageDigest;
import org.mortbay.util.Code;
import org.mortbay.util.Password;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.UnixCrypt;

public abstract class Credential {
    public abstract boolean check(Object var1);

    public static Credential getCredential(String credential) {
        if (credential.startsWith("CRYPT:")) {
            return new Crypt(credential);
        }
        if (credential.startsWith("MD5:")) {
            return new MD5(credential);
        }
        return new Password(credential);
    }

    public static class MD5
    extends Credential {
        public static final String __TYPE = "MD5:";
        private static MessageDigest __md;
        private byte[] _digest;

        MD5(String digest) {
            digest = digest.startsWith(__TYPE) ? digest.substring(__TYPE.length()) : digest;
            this._digest = TypeUtil.parseBytes(digest, 16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean check(Object credentials) {
            try {
                byte[] digest = null;
                if (credentials instanceof Password || credentials instanceof String) {
                    String string = __TYPE;
                    synchronized (__TYPE) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(credentials.toString().getBytes(StringUtil.__ISO_8859_1));
                        digest = __md.digest();
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                    }
                } else {
                    Code.warning("Can't check " + credentials.getClass() + " against MD5");
                }
                {
                    if (digest == null || digest.length != this._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < digest.length; ++i) {
                        if (digest[i] == this._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (Exception e) {
                Code.warning(e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String password) {
            try {
                String string = __TYPE;
                synchronized (__TYPE) {
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception e) {
                            Code.warning(e);
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(password.getBytes(StringUtil.__ISO_8859_1));
                    byte[] digest = __md.digest();
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return __TYPE + TypeUtil.toString(digest, 16);
                }
            }
            catch (Exception e) {
                Code.warning(e);
                return null;
            }
        }
    }

    public static class Crypt
    extends Credential {
        public static final String __TYPE = "CRYPT:";
        private String _cooked;

        Crypt(String cooked) {
            this._cooked = cooked.startsWith(__TYPE) ? cooked.substring(__TYPE.length()) : cooked;
        }

        public boolean check(Object credentials) {
            if (!(credentials instanceof String) && !(credentials instanceof Password)) {
                Code.warning("Can't check " + credentials.getClass() + " against CRYPT");
            }
            String passwd = credentials.toString();
            return this._cooked.equals(UnixCrypt.crypt(passwd, this._cooked));
        }

        public static String crypt(String user, String pw) {
            return __TYPE + UnixCrypt.crypt(pw, user);
        }
    }
}

