/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SSORealm;
import org.mortbay.http.UserPrincipal;
import org.mortbay.util.Code;
import org.mortbay.util.Credential;

public class HashSSORealm
implements SSORealm {
    public static final String SSO_COOKIE_NAME = "SSO_ID";
    private HashMap _ssoId2Principal = new HashMap();
    private HashMap _ssoUsername2Id = new HashMap();
    private HashMap _ssoPrincipal2Credential = new HashMap();
    private transient Random _random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential getSingleSignOn(HttpRequest request, HttpResponse response) {
        String ssoID = null;
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(SSO_COOKIE_NAME)) continue;
            ssoID = cookies[i].getValue();
            break;
        }
        Code.debug((Object)"get ssoID=", ssoID);
        UserPrincipal principal = null;
        Credential credential = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            principal = (UserPrincipal)this._ssoId2Principal.get(ssoID);
            credential = (Credential)this._ssoPrincipal2Credential.get(principal);
        }
        Code.debug((Object)"SSO principal=", (Object)principal);
        if (principal != null && credential != null) {
            if (principal.isAuthenticated()) {
                request.setUserPrincipal(principal);
                request.setAuthUser(principal.getName());
                return credential;
            }
            hashMap = this._ssoId2Principal;
            synchronized (hashMap) {
                this._ssoId2Principal.remove(ssoID);
                this._ssoPrincipal2Credential.remove(principal);
                this._ssoUsername2Id.remove(principal.getName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSingleSignOn(HttpRequest request, HttpResponse response, UserPrincipal principal, Credential credential) {
        String ssoID = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            while (this._ssoId2Principal.containsKey(ssoID = Long.toString(Math.abs(this._random.nextLong()), 30 + (int)(System.currentTimeMillis() % 7L)))) {
            }
            Code.debug((Object)"set ssoID=", (Object)ssoID);
            this._ssoId2Principal.put(ssoID, principal);
            this._ssoPrincipal2Credential.put(principal, credential);
            this._ssoUsername2Id.put(principal.getName(), ssoID);
        }
        Cookie cookie = new Cookie(SSO_COOKIE_NAME, ssoID);
        cookie.setPath("/");
        response.addSetCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSingleSignOn(String username) {
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            Object ssoID = this._ssoUsername2Id.remove(username);
            Object principal = this._ssoId2Principal.remove(ssoID);
            this._ssoPrincipal2Credential.remove(principal);
        }
    }
}

