/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils.tools;

import eclipseme.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public abstract class AbstractJavaTool {
    public static final String JAVA_APP_LAUNCH_ID = "org.eclipse.jdt.launching.localJavaApplication";

    protected abstract String[] getArguments();

    protected abstract String getClassName();

    protected abstract String[] getClasspath();

    protected abstract String getName();

    protected abstract String[] getVMArguments();

    public ILaunch launch(IProgressMonitor monitor) throws CoreException {
        Launch launch = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType(JAVA_APP_LAUNCH_ID);
        ILaunchConfigurationWorkingCopy launchConfig = launchType.newInstance(null, this.getName());
        this.fillLaunchConfig(launchConfig);
        launch = new Launch((ILaunchConfiguration)launchConfig, "run", null);
        ILaunchConfigurationDelegate delegate = launchType.getDelegate("run");
        delegate.launch((ILaunchConfiguration)launchConfig, "run", (ILaunch)launch, monitor);
        Utils.dumpCommandLine((ILaunch)launch);
        return launch;
    }

    private void fillLaunchConfig(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getClassName());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, this.getClasspathMementos());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArgumentsString());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArgumentsString());
    }

    private String getArgumentsString(String[] arguments) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < arguments.length) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append('\"').append(arguments[i]).append('\"');
            ++i;
        }
        return sb.toString();
    }

    private void addStandardLibraries(List mementos) throws CoreException {
        LibraryLocation[] libs;
        IVMInstall vm = JavaRuntime.getDefaultVMInstall();
        if (vm != null && (libs = JavaRuntime.getLibraryLocations((IVMInstall)vm)) != null) {
            int i = 0;
            while (i < libs.length) {
                IPath location = libs[i].getSystemLibraryPath();
                IRuntimeClasspathEntry r = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)location);
                r.setClasspathProperty(1);
                mementos.add(r.getMemento());
                ++i;
            }
        }
    }

    private List getClasspathMementos() throws CoreException {
        String[] cpEntries = this.getClasspath();
        ArrayList<String> mementos = new ArrayList<String>(cpEntries.length);
        int i = 0;
        while (i < cpEntries.length) {
            String cpEntry = cpEntries[i];
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)new Path(cpEntry), null, null);
            RuntimeClasspathEntry rcpEntry = new RuntimeClasspathEntry(entry);
            mementos.add(rcpEntry.getMemento());
            ++i;
        }
        this.addStandardLibraries(mementos);
        return mementos;
    }

    private String getProgramArgumentsString() {
        return this.getArgumentsString(this.getArguments());
    }

    private String getVMArgumentsString() {
        return this.getArgumentsString(this.getVMArguments());
    }
}

