/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils;

import eclipseme.EclipseMEPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class Utils {
    private static final byte[] buffer = new byte[1024];

    public static void copyFile(IFile sourceFile, IFile targetFile) throws IOException {
        Utils.copyFile(sourceFile.getLocation().toFile(), targetFile.getLocation().toFile());
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(sourceFile);
        FileOutputStream fos = new FileOutputStream(targetFile);
        Utils.copyInputToOutput(fis, fos);
        fis.close();
        fos.close();
    }

    public static void copyInputToOutput(InputStream input, OutputStream output) throws IOException {
        int bytesRead = 0;
        do {
            if ((bytesRead = input.read(buffer, 0, buffer.length)) <= 0) continue;
            output.write(buffer, 0, bytesRead);
        } while (bytesRead != -1);
    }

    public static void dumpCommandLine(ILaunch launch) {
        IProcess process;
        IProcess[] processes = launch.getProcesses();
        if (processes != null && processes.length > 0 && (process = processes[0]) != null) {
            String commandLine = process.getAttribute(IProcess.ATTR_CMDLINE);
            Utils.dumpCommandLine(commandLine);
        }
    }

    public static void dumpCommandLine(String commandLine) {
        String propValue = System.getProperty("eclipseme.dump.launch", "false");
        boolean doDump = propValue.equalsIgnoreCase("TRUE");
        if (doDump) {
            String text = commandLine == null ? "Command line not found" : "Command line: " + commandLine;
            EclipseMEPlugin.log(1, text);
        }
    }

    public static void dumpCommandLine(String[] commandLine) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            String string = commandLine[i];
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(string);
            ++i;
        }
        Utils.dumpCommandLine(sb.toString());
    }

    private Utils() {
    }
}

